<?php

namespace App\Http\Controllers\Backend\Setting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\UpdateAppearanceRequest;
use App\Http\Requests\Setting\UpdateFooterSettingRequest;
use App\Http\Requests\Setting\UpdateGeneralSettingRequest;
use App\Models\Setting;
use App\Traits\ImageUpload;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class SettingController extends Controller
{
    use ImageUpload;
    public function general()
    {

        return view('backend.settings.general');
    }

    public function generalUpdate(UpdateGeneralSettingRequest $request)
    {
//        dd($request);
        Setting::updateOrCreate(['name' => 'site_name'],['value' => $request->get('site_name')]);
        Artisan::call("env:set APP_NAME='".$request->get('site_name')."'");
        session(['site_name' => $request->get('site_name')]);
        Setting::updateOrCreate(['name' => 'site_title'],['value' => $request->get('site_title')]);
        session(['site_title' => $request->get('site_title')]);

        Setting::updateOrCreate(['name' => 'pre_broadcast_url'],['value' => $request->get('pre_broadcast_url')]);
        session(['pre_broadcast_url' => $request->get('pre_broadcast_url')]);

        Setting::updateOrCreate(['name' => 'broadcast_url'],['value' => $request->get('broadcast_url')]);
        session(['broadcast_url' => $request->get('broadcast_url')]);

        if($request->hasFile('site_logo')) {
            $imageName = $this->uploadImageUpdate('images/settings/appearance/', $request->site_logo, 'logo', setting('site_logo'));
            Setting::updateOrCreate(['name' => 'site_logo'],['value' => $imageName]);
            session(['site_logo' => $imageName]);
        }

        if($request->hasFile('site_favicon')) {
            $imageName = $this->uploadImageUpdate('images/settings/appearance/', $request->site_favicon, 'favicon', setting('site_favicon'));
            Setting::updateOrCreate(['name' => 'site_favicon'],['value' => $imageName]);
            session(['site_favicon' => $imageName]);
        }

        if($request->hasFile('pre_broadcast_video')) {
            $videoName = $this->uploadImageUpdate('images/settings/videos/', $request->pre_broadcast_video, 'video', setting('pre_broadcast_video'));
            Setting::updateOrCreate(['name' => 'pre_broadcast_video'],['value' => $videoName]);
            session(['pre_broadcast_video' => $videoName]);
        }

        notify()->success('General Setting Successfully Updated.');
        return redirect()->back();

    }

    public function appearance()
    {
        return view('backend.settings.appearance');
    }

    public function appearanceUpdate(UpdateAppearanceRequest $request)
    {
        if($request->hasFile('site_logo')) {
            $imageName = $this->uploadImageUpdate('images/settings/appearance/', $request->site_logo, 'logo', setting('site_logo'));
            Setting::updateOrCreate(['name' => 'site_logo'],['value' => $imageName]);
            session(['site_logo' => $imageName]);
        }
        if($request->hasFile('site_sm_logo')) {
            $imageName = $this->uploadImageUpdate('images/settings/appearance/', $request->site_sm_logo, 'smlogo', setting('site_sm_logo'));
            Setting::updateOrCreate(['name' => 'site_sm_logo'],['value' => $imageName]);
            session(['site_sm_logo' => $imageName]);
        }
        if($request->hasFile('site_favicon')) {
            $imageName = $this->uploadImageUpdate('images/settings/appearance/', $request->site_favicon, 'favicon', setting('site_favicon'));
            Setting::updateOrCreate(['name' => 'site_favicon'],['value' => $imageName]);
            session(['site_favicon' => $imageName]);
        }
        if($request->hasFile('site_og_image')) {
            $imageName = $this->uploadImageUpdate('images/settings/appearance/', $request->site_og_image, 'siteogimage', setting('site_og_image'));
            Setting::updateOrCreate(['name' => 'site_og_image'],['value' => $imageName]);
            session(['site_og_image' => $imageName]);
        }

        notify()->success('General Setting Successfully Updated.');
        return redirect()->back();
    }
    public function footer()
    {
        return view('backend.settings.footer');
    }

    public function footerUpdate(UpdateFooterSettingRequest $request) {

        Setting::updateOrCreate(['name' => 'site_facebook'],['value' => $request->get('site_facebook')]);
        Setting::updateOrCreate(['name' => 'site_instagram'],['value' => $request->get('site_instagram')]);
        Setting::updateOrCreate(['name' => 'site_footer_text'],['value' => $request->get('site_footer_text')]);
        if($request->hasFile('site_footer_logo')) {
            $imageName = $this->uploadImageUpdate('images/settings/footer/', $request->site_footer_logo, 'footerlogo', setting('site_footer_logo'));
            Setting::updateOrCreate(['name' => 'site_footer_logo'],['value' => $imageName]);
            session(['site_footer_logo' => $imageName]);
        }
        if($request->hasFile('site_download_profile')) {
            $imageName = $this->uploadImageUpdate('images/settings/appearance/', $request->site_download_profile, 'downloadprofile', setting('site_download_profile'));
            Setting::updateOrCreate(['name' => 'site_download_profile'],['value' => $imageName]);
            session(['site_download_profile' => $imageName]);
        }
        session([
            'site_facebook' => $request->get('site_facebook'),
            'site_instagram' => $request->get('site_instagram'),
            'site_footer_text' => $request->get('site_footer_text')
        ]);
        notify()->success('Footer Setting Successfully Updated.');
        return redirect()->back();

    }

    public function socialMedia()
    {
        return view('backend.settings.social_media');
    }

    public function socialMediaUpdate(UpdateFooterSettingRequest $request) {

        Setting::updateOrCreate(['name' => 'site_social_media_facebook'],['value' => $request->get('site_social_media_facebook')]);
        Setting::updateOrCreate(['name' => 'site_social_media_instagram'],['value' => $request->get('site_social_media_instagram')]);
        Setting::updateOrCreate(['name' => 'site_social_media_twitter'],['value' => $request->get('site_social_media_twitter')]);
        Setting::updateOrCreate(['name' => 'site_social_media_youtube'],['value' => $request->get('site_social_media_youtube')]);
        Setting::updateOrCreate(['name' => 'site_social_media_linkedin'],['value' => $request->get('site_social_media_linkedin')]);

        notify()->success('Social Media Setting Successfully Updated.');
        session([
            'site_social_media_facebook' => $request->get('site_social_media_facebook'),
            'site_social_media_instagram' => $request->get('site_social_media_instagram'),
            'site_social_media_twitter' => $request->get('site_social_media_twitter'),
            'site_social_media_youtube' => $request->get('site_social_media_youtube'),
            'site_social_media_linkedin' => $request->get('site_social_media_linkedin')
        ]);
        return redirect()->back();

    }

    public function delete($value)
    {
        Setting::where('name', $value)->update(['value'=> '']);
        session([ $value => '',]);
        return redirect()->route('admin.general.settings');
    }
}
