<?php

namespace App\Http\Controllers\Frontend;

use App\Events\TotalUserLoginEvent;
use App\Http\Controllers\Controller;
use App\Http\Requests\Career\StoreCareerRequest;
use App\Http\Requests\ContactMail\ContactMailRequest;
use App\Models\Presentation;
use App\Models\Question;
use App\Models\QuestionAnswer;
use App\Models\User;
use App\Models\UserLoginHistory;
use App\Traits\Bengali;
use App\Models\Career;
use App\Models\Category;
use App\Models\CommonSection;
use App\Models\ContactMail;
use App\Models\Dealer;
use App\Models\Media;
use App\Models\Module;
use App\Models\Page;
use App\Models\Product;
use App\Models\Progress;
use App\Models\Project;
use App\Models\ShowRoom;
use App\Models\SubCategory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class FrontEndController extends Controller
{
    public function index()
    {
//        broadcast( new TotalUserLoginEvent(auth()->user()));
        if(auth()->check()) {
            if(auth()->user()->user_type == 'admin' || auth()->user()->user_type == 'supper-admin') {
                return redirect()->route('home');
            } else {
                return redirect()->route('conference');
            }
        }
        return view('frontend.home');
    }

    public function conference ()
    {
        if(!session('user_history_uuid')) {
            $userIp = file_get_contents('https://api.ipify.org');

            $userIpDetails = '{}';
            if($userIp) {
                $userIpDetails = file_get_contents('http://ip-api.com/json/'.$userIp.'?fields=66846719');
            }

            $user_login_history = UserLoginHistory::create([
                'user_id' => auth()->user()->id,
                'entry_time' => Carbon::now()->toDateTimeLocalString(),
                'exit_time' => Carbon::now()->toDateTimeLocalString(),
                'user_ip' => $userIp,
                'user_ip_details' => $userIpDetails,
            ]);
            session(['user_history_uuid' => $user_login_history->uuid]);
        }

        $presentations = Presentation::get();
        return view('frontend.conference', compact('presentations'));
    }

    public function userActivity($user_uuid)
    {
//        $user = User::where('uuid', $user_uuid)->first();
//        if($user) {
//           $user = User::where('uuid', $user_uuid)->update([
//                'active_end_time' => date('Y-m-d H:i:s')
//            ]);
//        }
        $user = '';
        if(session('user_history_uuid')) {
            UserLoginHistory::where('uuid', session('user_history_uuid'))->update([
                'exit_time' => Carbon::now()->toDateTimeLocalString()
            ]);
        } else {
            $userIp = file_get_contents('https://api.ipify.org');
            $userIpDetails = '{}';
            if($userIp) {
                $userIpDetails = file_get_contents('http://ip-api.com/json/'.$userIp.'?fields=66846719');
            }

            $user_login_history = UserLoginHistory::create([
                'user_id' => auth()->user()->id,
                'entry_time' => Carbon::now()->toDateTimeLocalString(),
                'exit_time' => Carbon::now()->toDateTimeLocalString(),
                'user_ip' => $userIp,
                'user_ip_details' => $userIpDetails,
            ]);
            session(['user_history_uuid' => $user_login_history->uuid]);
        }
        return response()->json(session('user_history_uuid'));
    }




}
