<?php

namespace App\Http\Controllers\JoinAuth;

use App\Events\TotalUserLoginEvent;
use App\Http\Controllers\Controller;
use App\Http\Requests\JoinMeeting\JoinAuditorRequest;
use App\Http\Requests\JoinMeeting\JoinCompanyRequest;
use App\Http\Requests\JoinMeeting\JoinIndividualRequest;
use App\Http\Requests\JoinMeeting\JoinProxyRequest;
use App\Http\Requests\JoinMeeting\JoinSecretaryRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class JoinAuthController extends Controller
{
    public function joinIndividual(JoinIndividualRequest $request)
    {
        $individual = User::where('bo_id', $request->bo_folio_id)
                            ->where('shareholder_name',$request->shareholder_name)
                            ->where('total_share', $request->total_shares)
                            ->where('user_type', 'individual')
                            ->first();

        if($individual) {
            $this->userInfoUpdateForActiveLogin($individual);
        }
        notify()->error('Your Information not match. Please try again.');
        return redirect()->route('front');
    }

    public function joinCompany(JoinCompanyRequest $request)
    {
        $company    = User::where('bo_id', $request->bo_folio_id)
                            ->where('company_name',$request->organization_name)
                            ->where('authorized_person_name',$request->authorized_person_name)
                            ->where('total_share', $request->total_shares)
                            ->where('user_type', 'company')
                            ->first();
        if($company) {
            $this->userInfoUpdateForActiveLogin($company);
        }
        notify()->error('Your Information not match. Please try again.');
        return redirect()->route('front');
    }

    public function joinProxy(JoinProxyRequest $request)
    {
        $proxy      = User::where('bo_id', $request->bo_folio_id)
                            ->where('shareholder_name',$request->shareholder_name)
                            ->where('total_share', $request->total_shares)
                            ->where('authorized_person_name',$request->authorized_person_name)
                            ->where('user_type', 'proxy')
                            ->first();
        if($proxy) {
            $this->userInfoUpdateForActiveLogin($proxy);
        }
        notify()->error('Your Information not match. Please try again.');
        return redirect()->route('front');
    }

    public function joinSecretary(JoinSecretaryRequest $request)
    {
        $secretary      = User::where('email', $request->board_login_id)
                                ->where('user_type', 'board-member')
                                ->first();
        if($secretary) {
            $this->userInfoUpdateForActiveLogin($secretary);
        }
        notify()->error('Your Information not match. Please try again.');
        return redirect()->route('front');
    }

    public function joinAuditor(JoinAuditorRequest $request)
    {
        $auditor      = User::where('email', $request->board_login_id)
                                ->where('user_type', 'auditor')
                                ->first();
        if($auditor) {
            $this->userInfoUpdateForActiveLogin($auditor);
        }
        notify()->error('Your Information not match. Please try again.');
        return redirect()->route('front');
    }


    private function userInfoUpdateForActiveLogin($loginInfo)
    {
        DB::beginTransaction();
        try {

            Auth::login($loginInfo);

            User::where('id', Auth::user()->id)->update([
                'user_logged' => date("Y-m-d H:i:s"),
                'is_active' => 1,
            ]);


            broadcast(new TotalUserLoginEvent());

            DB::commit();
            return redirect()->route('conference');
        } catch (\Exception $e) {
            DB::rollback();
            notify()->error('Something went wrong!'.$e->getMessage());
            return redirect()->route('conference');
        }
    }
}
