<?php

namespace App\Http\Livewire\Frontend;

use App\Events\QuestionAnswerResultEvent;
use App\Models\Question;
use App\Models\QuestionAnswer;
use App\Models\QuestionOptions;
use App\Models\QuestionResult;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class AgendaWithResultLivewire extends Component
{
    public  $agendaWithAnswers;
    public  $userQuestionAnswerId;


    public function render()
    {
        $this->agendaWithAnswers = Question::with('questionOptionR','positiveResultOption')
                                            ->with('questionAnswerFirstTwoUser')
                                            ->where('is_active', 1)
                                            ->get();

        if(in_array(Auth::user()->user_type,['individual','company','proxy'])) {
            $this->userQuestionAnswerId = QuestionAnswer::select('question_id')
                                                        ->where('user_id', Auth::user()->id)
                                                        ->groupBy('question_id')->get();
        }

        return view('livewire.frontend.agenda-with-result-livewire');
    }

    protected $listeners = [
        "echo-private:QuestionAnswerPercentageReload,QuestionAnswerResultEvent" => 'QuestionAnswerResultEvent',
    ];

    public function QuestionAnswerResultEvent()
    {
        $this->agendaWithAnswers = Question::with('questionOptionR')
                                            ->where('is_active', 1)
                                            ->get();
    }

    public function QuestionAnswerById($id)
    {
        $question_option = QuestionOptions::where('id', $id)->first();

        if($question_option) {
            if(in_array(Auth::user()->user_type, ['individual','proxy','company'])) {
                if($question_option->type == 'Yes/No') {
                    $question_answer = QuestionAnswer::where('question_id', $question_option->question_id)->where('user_id', \auth()->user()->id)->first();

                    if($question_answer) {
//                        if($question_answer->question_option_id == $id) {
//
//                        } else {
//                            QuestionAnswer::where('question_id', $question_option->question_id)->where('user_id', \auth()->user()->id)->update([
//                                'question_option_id'     =>  $id,
//                            ]);
//                            $this->vote = true;
                            $this->emit('warningRepeatVoteShow');
//                        }

                    } else {
                        $userIp = file_get_contents('https://api.ipify.org');
                        $userIpDetails = '';
                        if($userIp) {
                            $userIpDetails = file_get_contents('http://ip-api.com/json/'.$userIp.'?fields=66846719');
                        }
                        QuestionAnswer::create([
                            'question_id'            => $question_option->question_id,
                            'question_option_id'     => $id,
                            'user_id'                => Auth::user()->id,
                            'user_ip'                => $userIp,
                            'user_ip_details'        => $userIpDetails,
                        ]);


                        $this->vote = true;
                        $this->emit('alertMessageShow');
                    }

                    $question_options = QuestionOptions::select('id','question_id','option')->where('question_id',$question_option->question_id)->get();
                    $question_wise_answer_total_count = QuestionAnswer::where('question_id', $question_option->question_id)->count();

                    if(count($question_options) > 0) {
                        foreach ($question_options  as $question_option_value) {

                            $question_result = QuestionResult::where('question_id', $question_option_value->question_id)
                                ->where('question_option_id', $question_option_value->id)
                                ->first();
                            $questionOptionCount = QuestionAnswer::where('question_id', $question_option_value->question_id)
                                ->where('question_option_id', $question_option_value->id)
                                ->count();

                            $quantity_percentage = $questionOptionCount > 0 ? (($questionOptionCount / $question_wise_answer_total_count ) * 100 )  : 0;
                            if($question_result) {
                                QuestionResult::where('question_id', $question_option_value->question_id)
                                    ->where('question_option_id', $question_option_value->id)
                                    ->update([
                                        'vote_quantity'          =>  $questionOptionCount,
                                        'percentage'             =>  is_float($quantity_percentage) ? number_format($quantity_percentage, 2) : $quantity_percentage,
                                    ]);
                            } else {
                                QuestionResult::create([
                                    'question_id'            =>  $question_option_value->question_id,
                                    'question_option_id'     =>  $question_option_value->id,
                                    'vote_quantity'          =>  $questionOptionCount,
                                    'percentage'             =>  is_float($quantity_percentage) ? number_format($quantity_percentage, 2) : $quantity_percentage,
                                ]);
                            }

                        }
                    }
                    broadcast(New QuestionAnswerResultEvent());
//                    $this->emit('closeYourLoading');

                }
            } else {
                $this->notEligibleUserWarning();

            }
        }
    }

    public function warningRepeatVoteShow()
    {


        $this->emit('warningRepeatVoteShow');

        return true;
    }

    protected function notEligibleUserWarning()
    {
        $this->emit('alertMessageNotEligible');
        return true;
    }
}
