<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RepportViewMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if(auth()->check())
        {
            if(auth()->user()->user_type == 'supper-admin' || auth()->user()->user_type == 'admin' || auth()->user()->user_type == 'board-member' || auth()->user()->user_type == 'auditor')
            {
                return $next($request);
            } else {
                return redirect()->route('conference');
            }
        }
        return redirect()->route('front') ;

    }
}
