<?php

namespace App\Http\Requests\JoinMeeting;

use Illuminate\Foundation\Http\FormRequest;

class JoinProxyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'bo_folio_id'             => 'required | string',
            'shareholder_name'        => 'required | string',
            'total_shares'            => 'required | between:0,10000000.99',
            'authorized_person_name'  => 'required | string',
        ];
    }
}
