<?php

namespace App\Http\Requests\Setting;

use Illuminate\Foundation\Http\FormRequest;

class UpdateGeneralSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'site_name'                     => 'required | string | min: 3 | max:180',
            'site_title'                    => 'nullable | string | max:180',
            'site_favicon'                  => 'nullable |image| max:200',
            'site_logo'                     => 'nullable |image| max:200',
            'pre_broadcast_video'           => 'nullable |mimes:mp4,mov,ogg,qt,ogv| max:200000',
            'pre_broadcast_url'             => 'nullable |string',
            'broadcast_url'                 => 'nullable |string',
        ];
    }
}
