<?php

namespace App\Http\Requests\SubCategory;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreSubCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $request = request();

        return [
            'name'              => ['required',  'string',  'max: 220',  Rule::unique('sub_categories')->where(function ($query)  use($request) {
                return $query->where('name', $request->name)->where('module_id',$request->module)->where('category_id', $request->category)->where('deleted_at', null);
            }),],
            'module'            => 'required | numeric | between:1,1000',
            'category'          => 'required | numeric | between:1,1000',
            'details'           => 'nullable | string',
            'image'             => 'required | image',
            'file_upload'       => 'nullable | mimes:pdf | max:15000',
            'status'            => 'nullable | in:on',
            'meta_keyword'      => 'nullable | string | max: 150',
            'meta_description'  => 'nullable | string | max: 400',
        ];
    }
}
