<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Webpatser\Uuid\Uuid;

class Question extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = ['id'];
    protected $hidden  = ['created_at', 'updated_at'];
    /**
     *  Setup model event hooks
     */
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $model->uuid = (string) Uuid::generate(4);
        });
    }

    /**
     * Get the route key for the model.
     *
     * @return string
     */
    public function getRouteKeyName()
    {
        return 'uuid';
    }

    public function options()
    {
        return $this->hasMany(QuestionOptions::class);
    }

    public function answers()
    {
        return $this->hasMany(QuestionAnswer::class);
    }

    public function questionResult()
    {
        return $this->hasMany(QuestionResult::class);
    }

    public function questionOptionR()
    {
        return $this->hasMany(QuestionOptions::class)->with('questionResultR');
    }

    public function positiveResultOption()
    {
        return $this->hasOne(QuestionOptions::class)->with('questionResultR')->where('is_active', 1);
    }

    public function questionAnswerFirstTwoUser()
    {
        return $this->hasOne(QuestionOptions::class)
//            ->with('questionAnsweredFirstTwo')
//                    ->join('question_answers','question_answers.question_option_id','question_options.id')
//                    ->join('users','users.id','question_answers.user_id')
                    ->where('is_active', 1);
    }
}
