@extends('layouts.frontend.frontend')
@push('back_header')
    @include('layouts.backend.common.header')
@endpush
@push('css')
    <link href="{{asset('assets/dashboard')}}/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <h6 class="mb-0 text-uppercase">Messages</h6>
            <hr/>
            <div class="card">
                <div class="card-body">
                    <div id="message-show-update">

                    </div>

                    <div class="table-responsive">
                        <table id="message-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>BO/Folio ID</th>
                                    <th>User</th>
                                    <th>Company</th>
                                    <th class="text-wrap">Message</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')

    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script>

        $(document).ready(function() {
            let table = $('#message-datatable').DataTable({
                // "order": [[0, "desc"]],
                processing: true,
                serverSide: true,
                stateSave: true,
                searchDelay: 300,
                ajax: {
                    url: "{!! route('admin.datatable.messages') !!}",
                    data: function ( d ) {
                        return $.extend({}, d, {
                            'search': d.search.value ? d.search.value : ''
                        });
                    }
                },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'bo_id', name: 'BO/Folio ID'},
                    {data: 'shareholder_name', name: 'User'},
                    {data: 'company_name', name: 'Company'},
                    {data: 'message', name: 'Message'},
                    {data: 'action', name: 'Action'},
                ],
            });
            table.order( [ 0, 'desc' ])
            table.draw();



        });
        function messageShow(messageId) {
            $.ajax({
                type:'get',
                url: '{!! url('admin/messages-approve') !!}/'+messageId,
                success: function (response) {
                    $('#message-show-update').html(` <div class="alert border-0 border-start border-5 border-success alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-success"><i class='bx bxs-check-circle'></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-success">${response ? (response.user ? response.user.bo_id : ''): '' }</h6>
                                <div>Message share change successfully</div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>`);
                },
                errors: function (err) {
                    console.log(error)
                },
            })
        }
    </script>
@endpush
