@extends('layouts.frontend.frontend')
@section('title', 'Question Option'))

@push('back_header')
    @include('layouts.backend.common.header')
@endpush
@section('content')
    <!--end breadcrumb-->
    <form  method="POST" id="form-edit-question-option" action="{{ route('admin.question.options.update',$question_option->id)  }}" >
        @csrf
       <div class="row">
            <div class="col-xl-12 mx-auto">
                <div class="d-flex">
                    <h6 class="mb-0 text-uppercase">{{ __((isset($question) ? 'Edit' : 'Create New') . ' Agenda') }}</h6>
                    <div class="ms-auto">
                        <div class="btn-group">
                            <a href="{{route('admin.questions.index')}}" class="btn btn-dark"><i class="lni lni-chevron-left"></i>{{ __('Back to list') }}</a>
                        </div>
                    </div>
                </div>
                <hr/>
                <div class="card border-top border-0 border-4 border-success">
                    <div class="card-body p-5">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('title')is-invalid @enderror" name="title" id="title" value="{{ isset($question) ? $question->title : old('title') }}" autocomplete="title" autofocus>
                                @error('title')
                                    <div class="invalid-feedback" >{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="active" name="is_active"  @isset($question) {{ $question->is_active ? 'checked' : '' }} @endisset>
                                    <label class="form-check-label" for="active">Active</label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            @if(isset($question))

                            @else
                                <div class="col-md-6">
                                    <label for="question-option-one" class="form-label">Question Option One <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('option')is-invalid @enderror" name="option_one" id="question-option-one" required>
                                    @error('option_one')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6">
                                    <label for="question-option-one" class="form-label">Question Option Two <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('option')is-invalid @enderror" name="option_two" id="question-option-one" required>
                                    @error('option_two')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                    @enderror
                                </div>
                            @endif
                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-primary px-5">@isset($question) Update  @else Create  @endisset</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
       </div>
    </form>
@endsection

@push('js')
    <script>

    </script>

    {!! JsValidator::formRequest('App\Http\Requests\Question\UpdateQuestionRequest','#form-update-question') !!}

    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>

@endpush
