@extends('layouts.frontend.frontend')

@push('css')
    <style>
        .nav {
            flex-direction: column;
        }
    </style>
@endpush
@section('content')
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="ps-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 p-0">
                    <li class="breadcrumb-item"><a href="{{route('home')}}"><i class="bx bx-home-alt"></i></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">Setting</li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col">
            <h6 class="mb-0 text-uppercase">Setting</h6>
            <hr/>
            <div class="row">
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            @include('backend.settings.setting_sidebar')
                        </div>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="card">
                        <div class="card-body">
                            <form action="{{route('admin.appearance.settings')}}" method="post" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-md-8">
                                        <label for="site-logo" class="form-label">Logo</label>
                                        <input type="file" class="form-control @error('site_logo')is-invalid @enderror" name="site_logo" id="site-logo">

                                        @error('site_logo')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                        <p>Image dimension (210*41) </p>
                                    </div>
                                    @if(session('site_logo'))
                                        <div class="col-md-4">
                                            <img src="{{asset(session('site_logo'))}}" style="max-width: 200px;">
                                        </div>
                                    @endif
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-8">
                                        <label for="site-sm-logo" class="form-label">Small Logo</label>
                                        <input type="file" class="form-control @error('site_sm_logo')is-invalid @enderror" name="site_sm_logo" id="site-sm-logo">

                                        @error('site_sm_logo')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                        <p>Image dimension (40*30) </p>
                                    </div>
                                    @if(session('site_sm_logo'))
                                        <div class="col-md-4">
                                            <img src="{{asset(session('site_sm_logo'))}}" style="max-width: 100px;">
                                        </div>
                                    @endif
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-8">
                                        <label for="site-favicon" class="form-label">Favicon</label>
                                        <input type="file" class="form-control @error('site_favicon')is-invalid @enderror" name="site_favicon" id="site-favicon">

                                        @error('site_favicon')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                        <p>Image dimension (16*16) </p>
                                    </div>
                                    @if(session('site_favicon'))
                                        <div class="col-md-4">
                                            <img src="{{asset(session('site_favicon'))}}"style="max-width: 40px;">
                                        </div>
                                    @endif
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-8">
                                        <label for="site-og-image" class="form-label">Og Image</label>
                                        <input type="file" class="form-control @error('site_og_image')is-invalid @enderror" name="site_og_image" id="site-og-image">

                                        @error('site_og_image')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                        <p>Image dimension (1200 * 630) </p>
                                    </div>
                                    @if(session('site_og_image'))
                                        <div class="col-md-4">
                                            <img src="{{asset(session('site_og_image'))}}" style="width: 100%">
                                        </div>
                                    @endif
                                </div>

                                <div class="col-12 mt-3">
                                    <button type="submit" class="btn btn-primary px-5">Update</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
