@extends('layouts.backend.backend')
@section('title','Footer Setting')
@push('css')
    <style>
        .nav {
            flex-direction: column;
        }
    </style>
@endpush
@section('content')
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="ps-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 p-0">
                    <li class="breadcrumb-item"><a href="{{route('home')}}"><i class="bx bx-home-alt"></i></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">Setting</li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col">
            <h6 class="mb-0 text-uppercase">Setting</h6>
            <hr/>
            <div class="row">
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                           @include('backend.settings.setting_sidebar')
                        </div>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="card">
                        <div class="card-body">
                            <div class="tab-content" id="pills-tabContent">
                                <form action="{{route('admin.footer.settings')}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                <div class="tab-pane fade {{Route::is('admin.footer.settings') ? 'show active' : ''}}" id="primary-pills-general" role="tabpanel">
                                    <div class="col-md-12">
                                        <label for="site-facebook" class="form-label">Facebook</label>
                                        <input type="text" class="form-control @error('site_facebook')is-invalid @enderror" name="site_facebook" id="site-facebook" value="{{session('site_facebook') ?? old('site_facebook')}}" required>

                                        @error('site_facebook')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-12">
                                        <label for="site-instagram" class="form-label">Instagram</label>
                                        <input type="text" class="form-control @error('site_instagram')is-invalid @enderror" name="site_instagram" id="site-instagram" value="{{session('site_instagram') ?? old('site_instagram')}}" required>

                                        @error('site_instagram')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-12 mt-2">
                                        <label for="site-footer-text" class="form-label">Footer Text</label>
                                        <textarea type="text" class="form-control @error('site_footer_text')is-invalid @enderror" name="site_footer_text" id="site-footer-text">{!!  session('site_footer_text') ?? old('site_footer_text')  !!}</textarea>
                                        @error('site_footer_text')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="row mt-3">
                                        <div class="col-md-8">
                                            <label for="site-footer-logo" class="form-label">Footer Logo</label>
                                            <input type="file" class="form-control @error('site_footer_logo')is-invalid @enderror" name="site_footer_logo" id="site-footer-logo" accept="image/png,image/jpeg,image/jpg">

                                            @error('site_footer_logo')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                            <p>Image dimension (210*45) </p>
                                        </div>
                                        @if(session('site_footer_logo'))
                                            <div class="col-md-4">
                                                <img src="{{asset(session('site_footer_logo'))}}" style="max-width: 100px;">
                                            </div>
                                        @endif
                                    </div>

                                    <div class="row mt-3">
                                        <div class="col-md-8">
                                            <label for="site-download-profile" class="form-label">Download Profile</label>
                                            <input type="file" class="form-control @error('site_download_profile')is-invalid @enderror" name="site_download_profile" id="site-download-profile"accept=".pdf">

                                            @error('site_download_profile')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>
                                        @if(session('site_download_profile'))
                                            <div class="col-md-4">
                                                <a href="{{asset(session('site_download_profile'))}}" style="max-width: 100px;" target="_blank">View Profile</a>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-12 mt-3">
                                        <button type="submit" class="btn btn-primary px-5">Update</button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
