@extends('layouts.frontend.frontend')
@push('meta_tag')
    <title>{{session('site_title')}}</title>
@endpush
@push('css')
    <link rel="stylesheet" href="{{asset('assets/dashboard/plugins/sweetalert2/sweetalert2.min.css')}}">
@endpush
@section('content')
    @push('front_menu')
        @include('layouts/frontend/front_menu')
    @endpush
    <div class="row">
        <div class="col-12 col-lg-12 col-xl-12 d-flex">
            <div class="card radius-10 w-100">
                <div class="row">
                    <div class="col-sm-12 col-md-5 col-lg-5">
                        <livewire:frontend.broadcast-handle-livewire />
                    </div>
                    <div class="col-sm-12 col-md-4 col-lg-4">
                        <div class="card-body">
                            <ul class="nav nav-pills nav-pills-success mb-4 " role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" data-bs-toggle="pill" href="#pills-agenda" role="tab" aria-selected="true">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Agenda</div>
                                        </div>
                                    </a>
                                </li>
                                @if(count($presentations) > 0)
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" data-bs-toggle="pill" href="#pills-presentation" role="tab" aria-selected="false">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Presentation</div>
                                        </div>
                                    </a>
                                </li>
                                @endif
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="pills-agenda" role="tabpanel">
                                    <div class="chat-wrapper ">
                                        <div class="agenda-chat-content text-center">
                                            <livewire:frontend.agenda-with-result-livewire />
                                        </div>
                                    </div>
                                </div>
                                @if(count($presentations) > 0)
                                <div class="tab-pane fade " id="pills-presentation" role="tabpanel">
                                    <div class="chat-wrapper ">
                                        <div class="presentation-chat-content text-center">
                                            @forelse($presentations as $presentation)
                                            <div class="card" style="margin: 20px;">
                                                <div class="card-body">
                                                    <div style="background-color: #DDDDDD; padding: 11px 0px;">
                                                        <h5 class="card-title">{{$presentation->title}}</h5>
                                                        @if($presentation->title_bn)
                                                        <h5 class="card-title">{{$presentation->title_bn}}</h5>
                                                        @endif
                                                    </div>
                                                    <div style="padding: 11px 0px;">
                                                        @if($presentation->details)
                                                            <p class="card-text">{!! $presentation->details !!}</p>
                                                        @endif
                                                        @if($presentation->details_bn)
                                                            <p class="card-text">{!! $presentation->details_bn !!}</p>
                                                        @endif
                                                        @if($presentation->image)
                                                            <img src="{{asset($presentation->image)}}" alt="" width="100%" style="max-height: 300px">
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            @empty
                                            @endforelse
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>

                        </div>
                        <div class="card-footer bg-white text-center" style="border: 0px;">
{{--                            <p>You need to click vote here each time to vote</p>--}}
{{--                            <button type="button" data-bs-toggle="modal" data-bs-target="#exampleScrollableModal" class="btn btn-outline-success">Vote Here</button>--}}
                            <div class="modal fade" id="" tabindex="-1" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-scrollable">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Agenda Vote</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                                        </div>
                                        <div id="agenda-vote-alert">

                                        </div>
                                        <div class="modal-body">
                                            <livewire:frontend.question-modal-livewire />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-12 col-md-3 col-lg-3">
                       <livewire:message />
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

{{--@push('loading')--}}
{{--    <div id="voting-loader" class="display-none">--}}
{{--        <div class="spinner-border text-success" role="status"> <span class="visually-hidden">Loading...</span>--}}
{{--        </div>--}}
{{--    </div>--}}
{{--@endpush--}}
@push('js')
    @if(in_array(\Illuminate\Support\Facades\Auth::user()->user_type, ['individual','proxy','company','board-member','auditor']))
        @php
            $user_uuid = auth()->user()->uuid;
        @endphp

        <script>
            localStorage.setItem("__login_user_browser",'{{$user_uuid}}');
            if(localStorage.getItem("__login_user_browser")) {
                setInterval(function (){
                    $.ajax({
                        type: 'get',
                        url: '{{url('user/activity')}}/'+localStorage.getItem("__login_user_browser"),
                        success: function (data){
                            console.log(data);
                        }
                    })
                }, 500000);
            }
        </script>
    @endif
    <script src="{{asset('assets/dashboard/plugins/sweetalert2/sweetalert2.all.min.js')}}"></script>
    <script>
        // $.getJSON('https://api.ipify.org?format=jsonp&callback=?', function(data) {
        //     console.log(JSON.stringify(data, null, 2));
        // });
        // new PerfectScrollbar('.chat-wrapper .chat-content');

        // new PerfectScrollbar('.chat-wrapper .presentation-chat-content');
        // new PerfectScrollbar('.chat-wrapper .agenda-chat-content');
        // $('.chat-content').each(function(){
        //     $(this).perfectScrollbar();
        // });
        // document.addEventListener('livewire:load', function () {
        //
        // });
        document.getElementsByClassName('chat-content')[0].scrollTop = document.getElementsByClassName('chat-content')[0].scrollHeight;
        $( document ).ready(function() {
            window.livewire.on('scroll', function()  {
                document.getElementsByClassName('chat-content')[0].scrollTop = document.getElementsByClassName('chat-content')[0].scrollHeight;
            });

            window.livewire.on('alertMessageShow', function()  {

                Swal.fire({
                    position: 'top',
                    icon: 'success',
                    title: 'Thanks for your valuable vote.',
                    showConfirmButton: false,
                    timer: 1500
                })
            });

            window.livewire.on('warningRepeatVoteShow', function()  {
                Swal.fire({
                    position: 'top',
                    icon: 'warning',
                    title: 'You already done your vote.',
                    showConfirmButton: false,
                    timer: 1500
                })
            });

            window.livewire.on('alertMessageNotEligible', function()  {
                Swal.fire({
                    position: 'top',
                    icon: 'warning',
                    title: 'You not eligible for vote',
                    showConfirmButton: false,
                    timer: 1500
                })
            });

            // window.livewire.on('showYourLoading', function()  {
            //    $('#voting-loader').removeClass('display-none');
            // });
            //
            // window.livewire.on('closeYourLoading', function()  {
            //    $('#voting-loader').addClass('display-none');
            // });

        });
    </script>
@endpush
