@extends('layouts.frontend.frontend')
@push('meta_tag')
    <title>{{session('site_title')}}</title>
@endpush
@push('front_header')
    @include('layouts.frontend.front_header')
@endpush
@section('content')

{{--    @if(date('d-m-Y') < date('26-12-2021'))--}}
{{--    <div class="row">--}}
{{--        <div class="col-12 ">--}}
{{--            <div class="card radius-10 w-100 justify-content-center" style="min-height: 55vh; align-items: center">--}}
{{--                <div class="row">--}}
{{--                    <div class="col m-auto ">--}}
{{--                        <div class="card-body p-lg-5 p-md-5 p-sm-5 text-center">--}}
{{--                            <h2>This site will be enabled from 10:30 AM on December 26, 2021. </h2>--}}
{{--                            <h2>Program will start soon. Please reload Browser.</h2>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--    </div>--}}
{{--    @endif--}}

{{--    @if(date('d-m-Y') <= date('26-12-2021'))--}}
        <div class="row">
        <div class="col-12 col-lg-12 col-xl-12 d-flex">
            <div class="card radius-10 w-100">
                <div class="row">
                    <div class="col-sm-12 col-md-7 col-lg-7">
                        <div class="card-body">
                            <div class="card-title">
                                <h5 class="my-4">Login as Shareholder</h5>
                                <hr>
                            </div>
                            <ul class="nav nav-pills nav-pills-success mb-4 " role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" data-bs-toggle="pill" href="#pills-home" role="tab" aria-selected="true">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Individual</div>
                                        </div>
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" data-bs-toggle="pill" href="#pills-profile" role="tab" aria-selected="false">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Organization</div>
                                        </div>
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" data-bs-toggle="pill" href="#pills-contact" role="tab" aria-selected="false">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Proxy</div>
                                        </div>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="pills-home" role="tabpanel">
                                    <form action="{{route('join.individual')}}" method="post" id="form-individual">
                                        @csrf
                                        <div class="row">
                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="bo-id-folio" class="form-label">BO/Folio ID</label>
                                                    <input class="form-control mb-3" name="bo_folio_id" type="text" id="bo-id-folio" placeholder="Enter Your BO / Folio ID" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="shareholder-name" class="form-label">Shareholder's Name</label>
                                                    <input class="form-control mb-3" name="shareholder_name" id="shareholder-name" type="text" placeholder="Enter Your Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="total-share" class="form-label">Total Shares(As on Record Date)</label>
                                                    <input class="form-control mb-3" id="total-share" name="total_shares" type="number" placeholder="Enter Your Total Shares(As on Record Date)" step="0.01">
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <button class="btn btn-success px-5 " type="submit" value="individual">Login</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>

                                <div class="tab-pane fade" id="pills-profile" role="tabpanel">
                                    <form action="{{route('join.company')}}" method="post" id="form-company">
                                        @csrf
                                        <div class="row">
                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-bo-id-folio" class="form-label">BO/Folio ID</label>
                                                    <input class="form-control mb-3" name="bo_folio_id" type="text" id="company-bo-id-folio" placeholder="Enter Your BO / Folio ID" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-name" class="form-label">Organization Name</label>
                                                    <input class="form-control mb-3" name="organization_name" id="company-name" type="text" placeholder="Enter Your Organization Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-authorized-person-name" class="form-label">Authorized Person Name</label>
                                                    <input class="form-control mb-3" name="authorized_person_name" id="company-authorized-person-name" type="text" placeholder="Enter Your Authorized Person Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-total-share" class="form-label">Total Shares(As on Record Date)</label>
                                                    <input class="form-control mb-3" name="total_shares" id="company-total-share" type="number" placeholder="Enter Your Total Shares(As on Record Date)" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <button class="btn btn-success px-5 " type="submit">Login</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>

                                <div class="tab-pane fade" id="pills-contact" role="tabpanel">
                                    <form action="{{route('join.proxy')}}" method="post" id="form-proxy">
                                        @csrf
                                        <div class="row">
                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-bo-id-folio" class="form-label">BO/Folio ID</label>
                                                    <input class="form-control mb-3" name="bo_folio_id" type="text" id="proxy-bo-id-folio" placeholder="Enter Your BO / Folio ID" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-shareholder-name" class="form-label">Shareholder's Name</label>
                                                    <input class="form-control mb-3" name="shareholder_name" id="proxy-shareholder-name" type="text" placeholder="Enter Your Shareholder's Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-total-share" class="form-label">Total Shares(As on Record Date)</label>
                                                    <input class="form-control mb-3" name="total_shares" id="proxy-total-share" type="number" placeholder="Enter Your Total Shares(As on Record Date)" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-authorized-person-name" class="form-label">Authorized Person Name</label>
                                                    <input class="form-control mb-3" name="authorized_person_name" id="proxy-authorized-person-name" type="text" placeholder="Enter Your Authorized Person Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <button class="btn btn-success px-5 " type="submit">Login</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-5 col-lg-5">
                        <div class="card-body">
                            <div class="card-title">
                                <h5 class="my-4">Login as Board Member/Company Secretary</h5>
                                <hr>
                            </div>
                            <form action="{{route('join.secretary')}}" method="post" id="form-secretary">
                                @csrf
                                <div class="row">

                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <label for="company-login" class="form-label">Login ID</label>
                                            <input class="form-control mb-3" name="board_login_id" type="text" id="company-login" placeholder="Enter Your Login ID" >
                                        </div>
                                    </div>
                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <button class="btn btn-success px-5 " type="submit">Login</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <div class="card-body">
                            <div class="card-title">
                                <h5 class="my-4">Login as Auditors/Scrutinizer</h5>
                                <hr>
                            </div>
                            <form action="{{route('join.auditor')}}" method="post" id="form-auditor">
                                @csrf
                                <div class="row">
                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <label for="auditors-login" class="form-label">Login ID</label>
                                            <input class="form-control mb-3" name="auditor_login_id" type="text" id="auditors-login" placeholder="Enter Your Login ID" >
                                        </div>
                                    </div>
                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <button class="btn btn-success px-5 " type="submit">Login</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
{{--    @endif--}}
@endsection

@push('js')
    {!! JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinIndividualRequest','#form-individual') !!}
    {!! JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinCompanyRequest', '#form-company') !!}
    {!! JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinProxyRequest', '#form-proxy') !!}
    {!! JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinSecretaryRequest', '#form-secretary') !!}
    {!! JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinAuditorRequest', '#form-auditor') !!}
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>


@endpush
