@extends('layouts.frontend.frontend')
@push('front_header')
    @include('layouts.frontend.front_header')
@endpush
@push('front_menu')
    @include('layouts/frontend/front_menu')
@endpush
@push('css')
    <link href="{{asset('assets/dashboard')}}/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex">
                <h6 class="mb-0 text-uppercase">Agenda Wise Votes</h6>
                <div class="ms-auto">
                    <div class="btn-group">
                        <a href="{{route('reports.agenda.vote.details.excel')}}" class="btn btn-white">{{ __('Excel') }}</a>
                    </div>
                </div>
            </div>

            <hr/>
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="vote-details-datatable" class="table table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th width="10%">Agenda</th>
                                    <th width="10%">Vote Total</th>
                                    <th width="86%">Details</th>
                                </tr>
                            </thead>
                            <tbody>
                            @forelse($questions as $question)
                                <tr >
                                    <td style="text-align: center;padding-top: 28px;">{{$question->title}}</td>
                                    <td style="text-align: center;padding-top: 28px;">{{$question->answers_count}}</td>
                                    <td style="padding: 0px;">
                                        <table class="table " style="margin-bottom: 0px">
                                            @forelse($question->questionResult as $question_result)

                                                <tr @if($loop->last) style="border-bottom: 0px solid #ffffff;" @else style="border-top: 0px solid #ffffff;" @endif>
                                                    <td width="20%">{{$question_result->questionOption->option}}</td>
                                                    <td width="40%">{{$question_result->vote_quantity}}</td>
                                                    <td width="40%">{{$question_result->percentage}}%</td>
                                                </tr>
                                            @empty

                                            @endforelse
                                        </table>
                                    </td>
                                </tr>
                            @empty
                            @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')

    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script>

        $(document).ready(function() {
            let table = $('#vote-details-datatable').DataTable({

            });
            {{--let table = $('#vote-details-datatable').DataTable({--}}
            {{--    "lengthMenu": [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],--}}
            {{--    iDisplayLength: 25,--}}
            {{--    // "order": [[0, "asc"]],--}}
            {{--    processing: true,--}}
            {{--    serverSide: true,--}}
            {{--    stateSave: true,--}}
            {{--    searchDelay: 300,--}}
            {{--    ajax: {--}}
            {{--        url: "{!! route('reports.login.histories.datatable') !!}",--}}
            {{--        method: 'GET',--}}
            {{--        data: function ( d ) {--}}
            {{--            return $.extend({}, d, {--}}
            {{--                'search': d.search.value ? d.search.value : ''--}}
            {{--            });--}}
            {{--        }--}}
            {{--    },--}}
            {{--    columns: [--}}
            {{--        {data: 'bo_id', name: 'Agenda'},--}}
            {{--        {data: 'name', "name": "Vote Total",},--}}
            {{--        {data: 'entry_time', name: 'Opinion'},--}}
            {{--        {data: 'exit_time', name: 'Vote Quantity'},--}}
            {{--        {data: 'duration', name: 'Vote Percentage'},--}}

            {{--    ],--}}
            {{--    dom: 'lBfrtip',--}}
            {{--    buttons: [--}}
            {{--        {--}}
            {{--            extend: 'collection',--}}
            {{--            text: 'Export',--}}
            {{--            buttons: [--}}
            {{--                'excel',--}}
            {{--                'csv',--}}
            {{--            ]--}}
            {{--        }--}}
            {{--    ],--}}
            {{--    // rowGroup: {--}}
            {{--        // endRender: function ( rows, group ) {--}}
            {{--        //     var avg = rows--}}
            {{--        //         .data()--}}
            {{--        //         .pluck(5)--}}
            {{--        //         .reduce( function (a, b) {--}}
            {{--        //             return a + b.replace(/[^\d]/g, '')*1;--}}
            {{--        //         }, 0) / rows.count();--}}
            {{--        //--}}
            {{--        //     // return 'Average salary in '+group+': '+--}}
            {{--        //     //     $.fn.dataTable.render.number(',', '.', 0, '$').display( avg );--}}
            {{--        // },--}}
            {{--        // dataSrc: function ( row ) {--}}
            {{--        //     console.log(row['bo_id'])--}}
            {{--        //     return row['bo_id'];--}}
            {{--        // }--}}
            {{--        // dataSrc: 1--}}
            {{--    // }--}}
            {{--});--}}
            {{--// table.order( [ 0, 'asc' ])--}}
            {{--table.draw();--}}
        });
    </script>
@endpush
