@extends('layouts.frontend.frontend')
@push('front_header')
    @include('layouts.frontend.front_header')
@endpush
@push('front_menu')
    @include('layouts/frontend/front_menu')
@endpush
@push('css')
    <link href="{{asset('assets/dashboard')}}/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <h6 class="mb-0 text-uppercase">Individual Votes</h6>
            <hr/>
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="votes-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                            <tr>
                                <th>BO/Folio ID</th>
                                <th class="text-wrap">Agenda</th>
                                <th class="text-wrap">Opinion</th>
                                <th class="text-wrap">IP</th>
                                <th class="text-wrap">Voting Time</th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')

    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script>

        $(document).ready(function() {
            let table = $('#votes-datatable').DataTable({
                "lengthMenu": [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
                iDisplayLength: 25,
                processing: true,
                serverSide: true,
                stateSave: true,
                searchDelay: 300,
                ajax: {
                    url: "{!! route('reports.votes.datatable') !!}",
                    data: function ( d ) {
                        return $.extend({}, d, {
                            'search': d.search.value ? d.search.value : ''
                        });
                    }
                },
                columns: [
                    {data: 'bo_id', name: 'BO/Folio ID'},
                    {data: 'title', name: 'Agenda'},
                    {data: 'option', name: 'Vote'},
                    {data: 'user_ip', name: 'IP'},
                    {data: 'voting_time', name: 'Voting Time'},
                ],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'collection',
                        text: 'Export',
                        buttons: [
                            'excel',
                            'csv',
                        ]
                    }
                ]
            });
            table.order( [ 4, 'desc' ])
            table.draw();
        });
    </script>
@endpush
