<?php

//users
Route::get('users',[\App\Http\Controllers\Backend\User\UserController::class,'index'])->name('users');
Route::get('datatable-users',[\App\Http\Controllers\Backend\User\UserController::class,'datatableUser'])->name('datatable.users');

//messages
Route::get('messages',[\App\Http\Controllers\Backend\Message\MessageController::class,'index'])->name('messages');
Route::get('datatable-messages',[\App\Http\Controllers\Backend\Message\MessageController::class,'datatableMessage'])->name('datatable.messages');
Route::get('messages-approve/{uuid}',[\App\Http\Controllers\Backend\Message\MessageController::class,'messageApprove'])->name('messages.approve');
Route::get('messages/edit',[\App\Http\Controllers\Backend\Message\MessageController::class,'edit'])->name('messages.edit');


//questions
Route::get('datatable-questions', [\App\Http\Controllers\Backend\Question\QuestionController::class,'datatableQuestion'])->name('datatable.questions');
Route::get('question-approve/{uuid}',[\App\Http\Controllers\Backend\Message\MessageController::class,'questionApprove'])->name('questions.approve');
Route::resource('questions', \App\Http\Controllers\Backend\Question\QuestionController::class);

//question options
Route::get('question-options/{uuid}',[\App\Http\Controllers\Backend\QuestionOption\QuestionOptionController::class,'questionOptions'])->name('question.options');
Route::get('question-options-edit/{id}',[\App\Http\Controllers\Backend\QuestionOption\QuestionOptionController::class,'questionOptionEdit'])->name('question.options.edit');
Route::post('question-options-update',[\App\Http\Controllers\Backend\QuestionOption\QuestionOptionController::class,'questionOptionUpdate'])->name('question.options.update');
Route::get('datatable-question-options',[\App\Http\Controllers\Backend\Message\MessageController::class,'datatableQuestionOptions'])->name('datatable.question.options');


//presentation
Route::delete('presentations/delete/{id}',[\App\Http\Controllers\Backend\Presentation\PresentationController::class, 'destroy'])->name('presentations.delete');
Route::resource('presentations',\App\Http\Controllers\Backend\Presentation\PresentationController::class)->except('show','destroy');



Route::get('data', function (){
    $analyticsData = Analytics::fetchVisitorsAndPageViews(\Spatie\Analytics\Period::days(7));
    dd($analyticsData);
});

Route::get('general/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'general'])->name('general.settings');
Route::post('general/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'generalUpdate'])->name('general.settings.update');

Route::get('appearance/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'appearance'])->name('appearance.settings');
Route::post('appearance/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'appearanceUpdate'])->name('appearance.settings.update');

Route::get('footer/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'footer'])->name('footer.settings');
Route::post('footer/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'footerUpdate'])->name('footer.settings.update');

Route::get('social/media/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'socialMedia'])->name('social.media.settings');
Route::post('social/media/settings', [App\Http\Controllers\Backend\Setting\SettingController::class,'socialMediaUpdate'])->name('social.media.settings.update');

Route::get('setting/file/delete/{name}', [App\Http\Controllers\Backend\Setting\SettingController::class,'delete'])->name('setting.file.delete');
