<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('websocket-run',function (){
//    \Artisan::call('websockets:serve');
//    dd('adf');
//});

Route::get('/', [\App\Http\Controllers\Frontend\FrontEndController::class,'index'])->name('front');

Route::post('/join/individual', [\App\Http\Controllers\JoinAuth\JoinAuthController::class,'joinIndividual'])->name('join.individual');
Route::post('/join/company', [\App\Http\Controllers\JoinAuth\JoinAuthController::class,'joinCompany'])->name('join.company');
Route::post('/join/proxy', [\App\Http\Controllers\JoinAuth\JoinAuthController::class,'joinProxy'])->name('join.proxy');
Route::post('/join/secretary', [\App\Http\Controllers\JoinAuth\JoinAuthController::class,'joinSecretary'])->name('join.secretary');
Route::post('/join/auditor', [\App\Http\Controllers\JoinAuth\JoinAuthController::class,'joinAuditor'])->name('join.auditor');

Route::get('/conference', [\App\Http\Controllers\Frontend\FrontEndController::class,'conference'])->name('conference')->middleware('conference');
Route::get('/user/activity/{user_uuid}', [\App\Http\Controllers\Frontend\FrontEndController::class,'userActivity'])->name('user.activity')->middleware('conference');
//Route::get('/messages', [\App\Http\Controllers\Frontend\Message\MessageController::class,'index'])->name('messages')->middleware('conference');
//Route::get('messages/edit',[\App\Http\Controllers\Frontend\Message\MessageController::class,'edit'])->name('messages.edit');

//report
Route::get('reports/dashboard',[\App\Http\Controllers\Frontend\ReportController::class,'reportDashboard'])->name('reports.dashboard')->middleware('report');

Route::get('reports/votes',[\App\Http\Controllers\Frontend\ReportController::class,'reportVotes'])->name('reports.votes')->middleware('report');
Route::get('reports/votes/datatable',[\App\Http\Controllers\Frontend\ReportController::class,'VoteDatatable'])->name('reports.votes.datatable')->middleware('report');

Route::get('reports/voters',[\App\Http\Controllers\Frontend\ReportController::class,'reportVoters'])->name('reports.voters')->middleware('report');
Route::get('reports/voters/datatable',[\App\Http\Controllers\Frontend\ReportController::class,'votersDatatable'])->name('reports.voters.datatable')->middleware('report');

Route::get('reports/attendances',[\App\Http\Controllers\Frontend\ReportController::class,'reportAttendances'])->name('reports.attendances')->middleware('report');
Route::get('reports/attendances/datatable',[\App\Http\Controllers\Frontend\ReportController::class,'attendancesDatatable'])->name('reports.attendances.datatable')->middleware('report');

Route::get('reports/login/histories',[\App\Http\Controllers\Frontend\ReportController::class,'loginHistory'])->name('reports.login.histories')->middleware('report');
Route::get('reports/login/histories/datatable',[\App\Http\Controllers\Frontend\ReportController::class,'loginHistoryDatatable'])->name('reports.login.histories.datatable')->middleware('report');

Route::get('reports/agenda/vote/details',[\App\Http\Controllers\Frontend\ReportController::class,'voteDetails'])->name('reports.agenda.vote.details')->middleware('report');
Route::get('reports/agenda/vote/details/excel',[\App\Http\Controllers\Frontend\ReportController::class,'voteDetailsExcel'])->name('reports.agenda.vote.details.excel')->middleware('report');

Route::get('admin-login', [\App\Http\Controllers\Backend\AdminLogin\AdminLoginController::class,'login'])->name('admin.login');

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
