<?php

namespace App\Exports;

use App\Models\Question;
use App\Models\QuestionResult;
use Illuminate\View\View;
use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\FromView;

class AgendaWiseVoteExport implements FromView
{
    public function view(): View
    {
        return view('frontend.report_exports.vote_detail_exports', [
            'vote_detail_exports' => Question::withCount('answers')->leftJoin('question_options', 'question_options.question_id', 'questions.id')
                ->leftJoin('question_results', 'question_results.question_option_id','question_options.id', 'questions.id')
                ->selectRaw('questions.title, question_results.vote_quantity,question_results.percentage, question_options.option ')
                ->get()
        ]);
    }
}
