<?php

namespace App\Http\Controllers\Backend\User;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class UserController extends Controller
{
    public function index()
    {
        return view('backend.users.index');
    }

    public function datatableUser()
    {
        $search = \request('search');
        $users = User::whereIn('user_type', ['individual','company','proxy'])
            ->when($search, function ($q) use ($search){
                $q->where('name','like','%'.$search.'%')
                    ->orWhere('shareholder_name','like','%'.$search.'%')
                    ->orWhere('company_name','like','%'.$search.'%')
                    ->orWhere('authorized_person_name','like','%'.$search.'%')
                    ->orWhere('user_type','like','%'.$search.'%')
                    ->orWhere('total_share','like','%'.$search.'%')
                    ->orWhere('bo_id','like','%'.$search.'%');
            })
            ->select([
                'name as user_name',
                'shareholder_name as shareholder_name',
                'company_name as company_name',
                'authorized_person_name as authorized',
                'bo_id as bo_id',
                'user_type as user_type',
                'total_share as total_share',
            ])->get();

        return DataTables::of($users)
            ->make(true);
    }
}
