<?php

namespace App\Http\Controllers\Frontend;

use App\Exports\AgendaWiseVoteExport;
use App\Http\Controllers\Controller;
use App\Models\Question;
use App\Models\QuestionAnswer;
use App\Models\QuestionResult;
use App\Models\User;
use App\Models\UserLoginHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\DataTables;

class ReportController extends Controller
{
    public function reportDashboard()
    {
        $total_voter = User::whereIn('user_type',['individual','company','proxy'])->count();
        $total_voting = QuestionAnswer::count();
        $total_attendance = User::whereIn('user_type',['individual','company','proxy'])->whereNotNull('user_logged')->count();

        return view('frontend.reports.dashboard', compact('total_voter','total_voting', 'total_attendance'));
    }


    public function reportVotes()
    {

        return view('frontend.reports.votes');
    }

    public function VoteDatatable()
    {
        $search = \request('search');

        $votes = QuestionAnswer::join('questions','questions.id', 'question_answers.question_id')
                                ->join('question_options','question_options.id', 'question_answers.question_option_id')
                                ->join('users','users.id', 'question_answers.user_id')
                                ->when($search, function ($q) use ($search){
                                    $q->where('users.bo_id','like','%'.$search.'%')
                                        ->orWhere('questions.proposed_resolution','like','%'.$search.'%')
                                        ->orWhere('question_options.option','like','%'.$search.'%')
                                        ->orWhere('question_answers.user_ip','like','%'.$search.'%');
                                })
                                ->select([
                                    'users.bo_id',
                                    'questions.proposed_resolution',
                                    'questions.title',
                                    'question_options.option',
                                    'question_answers.user_ip',
                                    'question_answers.created_at as voting_time'
                                ])->orderBy('users.bo_id')->get();

        return DataTables::of($votes)->make(true);
    }
    public function reportVoters()
    {

        return view('frontend.reports.voters');
    }

    public function votersDatatable()
    {
        $search = \request('search');

        $attendances = User::whereIn('user_type',['individual','company','proxy'])
            ->when($search, function ($q) use ($search){
                $q->where('bo_id','like','%'.$search.'%')
                    ->orWhere('shareholder_name','like','%'.$search.'%')
                    ->orWhere('company_name','like','%'.$search.'%')
                    ->orWhere('total_share','like','%'.$search.'%')
                    ->orWhere('authorized_person_name','like','%'.$search.'%');
            })
            ->select([
                'bo_id','shareholder_name','company_name','total_share','authorized_person_name'
            ])->orderBy('bo_id')->get();

        return DataTables::of($attendances)
            ->addColumn('name', function($attendance){
                if($attendance->shareholder_name) {
                    return $attendance->shareholder_name;
                } else if($attendance->company_name) {
                    return $attendance->company_name;
                } else if ($attendance->authorized_person_name) {
                    return $attendance->authorized_person_name;
                } else {
                    return '';
                }
            })->make(true);
    }

    public function reportAttendances()
    {

        return view('frontend.reports.attendances');
    }

    public function attendancesDatatable()
    {
        $search = \request('search');

        $attendances = User::whereNotNull('user_logged')
                            ->whereIn('user_type',['individual','company','proxy'])
                            ->when($search, function ($q) use ($search){
                                $q->where('bo_id','like','%'.$search.'%')
                                    ->orWhere('user_logged','like','%'.$search.'%')
                                    ->orWhere('shareholder_name','like','%'.$search.'%')
                                    ->orWhere('company_name','like','%'.$search.'%')
                                    ->orWhere('total_share','like','%'.$search.'%')
                                    ->orWhere('authorized_person_name','like','%'.$search.'%');
                            })
                            ->select([
                                'bo_id','user_logged','shareholder_name','company_name','total_share','authorized_person_name'
                            ])->orderBy('bo_id')->get();

        return DataTables::of($attendances)
            ->addColumn('name', function($attendance){
                if($attendance->shareholder_name) {
                    return $attendance->shareholder_name;
                } else if($attendance->company_name) {
                    return $attendance->company_name;
                } else if ($attendance->authorized_person_name) {
                    return $attendance->authorized_person_name;
                } else {
                    return '';
                }
            })->make(true);
    }

    public function loginHistory()
    {

        return view('frontend.reports.login_histories');
    }

    public function loginHistoryDatatable()
    {
        $search = \request('search');

        $login_histories = UserLoginHistory::join('users','users.id', 'user_login_histories.user_id')
                            ->whereIn('users.user_type',['individual','company','proxy'])
                            ->when($search, function ($q) use ($search){
                                $q->where('users.bo_id','like','%'.$search.'%')
                                    ->orWhere('users.shareholder_name','like','%'.$search.'%')
                                    ->orWhere('users.company_name','like','%'.$search.'%')
                                    ->orWhere('users.authorized_person_name','like','%'.$search.'%')
                                    ->orWhere('user_login_histories.user_ip','like','%'.$search.'%')
                                    ->orWhere('user_login_histories.entry_time','like','%'.$search.'%')
                                    ->orWhere('user_login_histories.exit_time','like','%'.$search.'%');
                            })
                            ->select([
                                'users.bo_id','users.shareholder_name','users.company_name','users.authorized_person_name',
                                'user_login_histories.entry_time','user_login_histories.exit_time'
                            ])->orderBy('entry_time', 'asc')->get();

        return DataTables::of($login_histories)
            ->addColumn('duration', function($login_history){
                $entry_time = new Carbon($login_history->entry_time);
                $exit_time = new Carbon($login_history->exit_time);
               return $entry_time->diff($exit_time)->format('%H:%I:%S');
            })->addColumn('name', function($login_history){
                if($login_history->shareholder_name) {
                    return $login_history->shareholder_name;
                } else if($login_history->company_name) {
                    return $login_history->company_name;
                } else if ($login_history->authorized_person_name) {
                    return $login_history->authorized_person_name;
                } else {
                    return '';
                }
            })
            ->make(true);
    }

    public function voteDetails ()
    {
        $questions  = Question::withCount('answers')
            ->with('questionResult')
            ->with('questionResult.questionOption')->get();

        return view('frontend.reports.vote_details', compact('questions'));
    }

    public function voteDetailsDatatable()
    {
        $search = \request('search');

        $questions =$agendas = Question::withCount('answers')
                                        ->with('questionResult')
                                        ->with('questionResult.option')
                                        ->when($search, function ($q) use ($search){
                                            $q->where('title','like','%'.$search.'%')
                                                ->orWhere('title_bn','like','%'.$search.'%');
                                        })->select([
                                        'title','title_bn'
                                    ]) ->get();

        return DataTables::of($questions)
            ->make(true);
    }

    public function voteDetailsExcel()
    {
//        QuestionResult::with('question')->get()->dd();
//        return Excel::download(new AgendaWiseVoteExport, 'vote_details.xlsx');
//        return (new AgendaWiseVoteExport)->download('vote_details.xlsx');
        return Excel::download(new AgendaWiseVoteExport, 'vote_details.xlsx');
    }
}
