<?php

namespace App\Http\Livewire;

use App\Models\User;
use Livewire\Component;

class UserTotalInfo extends Component
{
    public $userTotalActive = 0;
    public $userTotalActiveSahres = 0;

    public function render()
    {
        $userActiveTotalShare = User::selectRaw('count(*) as total_active, sum(total_share) as total_share')
            ->where('is_active', 1)
            ->whereIn('user_type', ['individual','company','proxy'])
            ->groupBy('is_active')
            ->first();

        $this->userTotalActive   =  $userActiveTotalShare ? $userActiveTotalShare->total_active : 0;
        $this->userTotalActiveSahres    =  $userActiveTotalShare ? $userActiveTotalShare->total_share : 0;
        return view('livewire.user-total-info');
    }

    public function getListeners()
    {
        return [
            "echo-private:TotalUserLogin,TotalUserLoginEvent" => 'TotalUserInfoChange',
        ];
    }

    public function TotalUserInfoChange()
    {
        $userActiveTotalShare = User::selectRaw('count(*) as total_active, sum(total_share) as total_share')
                                    ->where('is_active', 1)
                                    ->whereIn('user_type', ['individual','company','proxy'])
                                    ->groupBy('is_active')
                                    ->first();

        $this->userTotalActive   =  $userActiveTotalShare ? $userActiveTotalShare->total_active : 0;
        $this->userTotalActiveSahres    =  $userActiveTotalShare ? $userActiveTotalShare->total_share : 0;
    }
}
