<?php

namespace App\Http\Requests\Question;

use Illuminate\Foundation\Http\FormRequest;

class StoreQuestionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'                         => 'required | string |  max: 200',
            'title_bn'                      => 'nullable | string |  max: 200',
            'details'                       => 'nullable | string |  max: 1000',
            'details_bn'                    => 'nullable | string |  max: 1000',
            'proposed_resolution'           => 'nullable | string |  max: 1000',
            'proposed_resolution_bn'        => 'nullable | string |  max: 1000',
            'total_shareholder_quantity'    => 'nullable | integer',
            'total_share_quantity'          => 'nullable | between:0,9999999999.99',
            'is_active'                     => 'nullable | in:on',
            'option_one'                    => 'required | string | max: 200',
            'option_two'                    => 'required | string | max: 200',
        ];
    }
}
