<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid');
            $table->string('email')->nullable();
            $table->string('name')->nullable();
            $table->string('bo_id')->nullable()->comment('individual,company,proxy');
            $table->string('shareholder_name')->nullable()->comment('individual,proxy');
            $table->string('company_name')->nullable()->comment('company');
            $table->string('authorized_person_name')->nullable()->comment('company,proxy');
            $table->string('total_share')->nullable()->comment('individual,company,proxy');
            $table->string('user_type')->nullable()->comment('individual,company,proxy,board-member,auditor,supper-admin,admin,user');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->unsignedBigInteger('role_id')->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
