<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuestionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('questions', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid');
            $table->string('title');
            $table->string('title_bn')->nullable();
            $table->text('details')->nullable();
            $table->text('details_bn')->nullable();
            $table->text('proposed_resolution')->nullable();
            $table->text('proposed_resolution_bn')->nullable();
            $table->float('total_shareholder_quantity')->nullable();
            $table->float('total_share_quantity')->nullable();
            $table->tinyInteger('is_active')->default(1);
            $table->unsignedBigInteger('crated_by')->nullable();
            $table->unsignedBigInteger('update_by')->nullable();
            $table->foreign('crated_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('update_by')->references('id')->on('users')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('questions');
    }
}
