@extends('layouts.frontend.frontend')
@section('title',__((isset($presentation) ? 'Edit' : 'Create New') . ' Presentation'))
@push('css')
{{--    <link href="{{asset('assets/dashboard')}}/plugins/summernote/summernote-lite.css" rel="stylesheet" />--}}
@endpush
@push('back_header')
    @include('layouts.backend.common.header')
@endpush
@section('content')
    <!--end breadcrumb-->
    <form  method="POST" id="{{isset($presentation) ? 'form-update-presentation' : 'form-create-presentation'}}" action="{{ isset($presentation) ? route('admin.presentations.update',$presentation->uuid) : route('admin.presentations.store') }}" enctype="multipart/form-data">
        @csrf
        @isset($presentation)
            @method('PUT')
        @endisset
        <div class="row">
            <div class="d-flex">
                <h6 class="mb-0 text-uppercase">{{ __((isset($presentation) ? 'Edit' : 'Create New') . ' Presentation') }}</h6>
                <div class="ms-auto">
                    <div class="btn-group">
                        <a href="{{route('admin.presentations.index')}}" class="btn btn-dark"><i class="lni lni-chevron-left"></i>{{ __('Back to list') }}</a>
                    </div>
                </div>
            </div>
        </div>

       <div class="row">
            <div class="{{isset($presentation) ? 'col-xl-8' : 'col-xl-12'}} ">

                <hr/>
                <div class="card border-top border-0 border-4 border-success">
                    <div class="card-body p-5">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('title')is-invalid @enderror" name="title" id="title" value="{{ isset($presentation) ? $presentation->title : old('title') }}" autocomplete="title" autofocus>
                                @error('title')
                                    <div class="invalid-feedback" >{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="title-bn" class="form-label">Title BN</label>
                                <input type="text" class="form-control @error('title_bn')is-invalid @enderror" name="title_bn" id="title-bn" value="{{ isset($presentation) ? $presentation->title_bn : old('title_bn') }}" >
                                @error('title_bn')
                                    <div class="invalid-feedback" >{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="details" class="form-label">Details </label>
                                <textarea name="details"  class="form-control @error('details')is-invalid @enderror" > {{ isset($presentation) ? $presentation->details : old('details') }}</textarea>
                                @error('details')
                                    <div class="invalid-feedback" >{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="details-bn" class="form-label">Details BN</label>
                                <textarea name="details_bn" id="details-bn"  class="form-control @error('details_bn')is-invalid @enderror" > {{ isset($presentation) ? $presentation->details_bn : old('details_bn') }}</textarea>
                                @error('details_bn')
                                    <div class="invalid-feedback" >{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="image" class="form-label">Image</label>
                                <input type="file" class="form-control @error('image')is-invalid @enderror" name="image" id="image" />
                                @error('image')
                                    <div class="invalid-feedback" >{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="active" name="is_active"  @isset($presentation) {{ $presentation->is_active ? 'checked' : '' }} @endisset>
                                    <label class="form-check-label" for="active">Active</label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12 mt-3">
                                <button type="submit" class="btn btn-primary px-5">@isset($presentation) Update  @else Create  @endisset</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
           @isset($presentation)
           <div class="col-xl-4 ">
               <hr/>
               <div class="card border-top border-0 border-4 border-success">
                   <div class="card-body p-5">
                       <lable>Image</lable>
                       <div>
                           <img src="{{asset($presentation->image)}}" alt="" style="max-height: 220px;">
                       </div>
                   </div>
               </div>
           </div>
           @endisset
       </div>
    </form>
@endsection

@push('js')
{{--    <script src="{{asset('assets/dashboard')}}/plugins/summernote/summernote-lite.js"></script>--}}
    <script>
        // let editor = $('.summernote1');
        // editor.summernote({
        //     height: 200,
        //     // focus: true,
        //     buttons: {
        //         filemanager: filemanager.btnSummernote,
        //     },
        //     fontSizes: ['8', '9', '10', '11', '12', '13', '14', '15', '16', '18', '20', '22' , '24', '28', '32', '36', '40', '48'],
        //     fontSizeUnits: ['px'],
        //     toolbar: [
        //         ['style', ['style']],
        //         ['font', ['bold', 'italic', 'underline', 'clear']],
        //         ['fontsize', ['fontsize']],
        //         ['fontname', ['fontname']],
        //         ['color', ['color']],
        //         ['para', ['ul', 'ol', 'paragraph']],
        //         ['height', ['height']],
        //         ['table', ['table']],
        //         ['insert', ['link', 'hr']],
        //         ['view', ['fullscreen', 'codeview']],
        //         ['custom', ['filemanager']]
        //     ],
        //
        // });
        // window.addEventListener('filemanager.select', function (e) {
        //     var data = e.detail.data;
        //     $(data.note).summernote('editor.insertImage', data.absolute_url)
        // });
    </script>
    @isset($presentation)
        {!! JsValidator::formRequest('App\Http\Requests\Presentation\UpdatePresentationRequest','#form-update-presentation') !!}
    @else
        {!! JsValidator::formRequest('App\Http\Requests\Presentation\StorePresentationRequest','#form-create-presentation') !!}
    @endisset
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>

@endpush
