@extends('layouts.frontend.frontend')
@section('title','General Setting')
@push('css')
    <style>
        .nav {
            flex-direction: column;
        }
    </style>
@endpush
@push('back_header')
    @include('layouts.backend.common.header')
@endpush
@section('content')

    <!--end breadcrumb-->
    <div class="row">
        <div class="col">
            <h6 class="mb-0 text-uppercase">Setting</h6>
            <hr/>
            <div class="row">
                <div class="col-md-9">
                    <div class="card">
                        <div class="card-body">
                            <div class="tab-content" id="pills-tabContent">
                                <form action="{{route('admin.general.settings')}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                <div class="tab-pane fade {{Route::is('admin.general.settings') ? 'show active' : ''}}" id="primary-pills-general" role="tabpanel">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="site-name" class="form-label">Site Name</label>
                                            <input type="text" class="form-control @error('site_name')is-invalid @enderror" name="site_name" id="site-name" value="{{session('site_name') ?? old('site_name')}}" required>

                                            @error('site_name')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-md-6">
                                            <label for="site-title" class="form-label">Site Title</label>
                                            <input type="text" class="form-control @error('site_title')is-invalid @enderror" name="site_title" id="site-title" value="{{session('site_title') ?? old('site_title')}}" required>

                                            @error('site_title')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="site-link-text" class="form-label">Total Share</label>
                                            <input type="text" class="form-control @error('site_link_text')is-invalid @enderror" name="site_link_text" id="site-link-text" value="{{session('site_link_text') ?? old('site_link_text')}}" >

                                            @error('site_link_text')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-md-6">
                                            <label for="site-link" class="form-label">Total Shareholder</label>
                                            <input type="text" class="form-control @error('site_link')is-invalid @enderror" name="site_link" id="site-link" value="{{session('site_link') ?? old('site_link')}}" >

                                            @error('site_link')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <label for="site-logo" class="form-label">Logo</label>
                                            <input type="file" class="form-control @error('site_logo')is-invalid @enderror" name="site_logo" id="site-logo">
                                            @error('site_logo')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <div class="col-md-6">
                                            <label for="site-favicon" class="form-label">Favicon</label>
                                            <input type="file" class="form-control @error('site_favicon')is-invalid @enderror" name="site_favicon" id="site-favicon">

                                            @error('site_favicon')
                                                <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-md-6">
                                            <label for="broadcast-video" class="form-label">Pre Broadcast Video</label>
                                            <input type="file" class="form-control @error('pre_broadcast_video')is-invalid @enderror" name="pre_broadcast_video" id="broadcast-video">

                                            @error('pre_broadcast_video')
                                                <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-md-6 ">
                                            <label for="agm-pre-broadcast" class="form-label">Pre Broadcast URL</label>
                                            <textarea type="text" class="form-control @error('pre_broadcast_url')is-invalid @enderror" name="pre_broadcast_url" id="agm-pre-broadcast" rows="1">{!!  session('pre_broadcast_url') ?? old('pre_broadcast_url')  !!}</textarea>
                                            @error('pre_broadcast_url')
                                                <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-md-6 ">
                                            <label for="agm-broadcast" class="form-label">AGM Broadcast URL</label>
                                            <textarea type="text" class="form-control @error('broadcast_url')is-invalid @enderror" name="broadcast_url" id="agm-broadcast" rows="1">{!!  session('broadcast_url') ?? old('broadcast_url')  !!}</textarea>
                                            @error('broadcast_url')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-12 mt-3">
                                        <button type="submit" class="btn btn-primary px-5">Update</button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                           <div class="row">
                               <div class="col-md-6">
                                   <h6>Pre Broadcast</h6>
                                   {!! session('pre_broadcast_url') !!}
                               </div>
                               <div class="col-md-6">
                                   <h6>Broadcast</h6>
                                   {!! session('broadcast_url') !!}
                               </div>
                           </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                            @if(session('site_logo'))
                                <div class="col-md-12">
                                    <label  class="form-label">Logo</label>
                                    <img src="{{asset(session('site_logo'))}}"style="max-width: 200px;">
                                </div>
                            @endif

                            @if(session('site_favicon'))
                                <div class="col-md-12">
                                    <label class="form-label">Favicon</label>
                                    <img src="{{asset(session('site_favicon'))}}"style="max-width: 40px;">
                                </div>
                            @endif

                            @if(session('pre_broadcast_video'))
                                <div class="col-md-12">
                                    <video id="myVideo" width="100%"  controls >
                                        <source src="{{asset(session('pre_broadcast_video') )}}" >
                                        Your browser does not support HTML video.
                                    </video>
                                </div>
                                <a href="{{route('admin.setting.file.delete',['name'=> 'pre_broadcast_video'])}}" class="btn btn-danger" onclick="return confirm('Are you sure?')"><i class="lni lni-trash"></i></a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
