@extends('layouts.backend.backend')
@section('title','Social Media Links')
@push('css')
    <style>
        .nav {
            flex-direction: column;
        }
    </style>
@endpush
@section('content')
    <!--breadcrumb-->
    <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
        <div class="ps-3">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 p-0">
                    <li class="breadcrumb-item"><a href="{{route('home')}}"><i class="bx bx-home-alt"></i></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">Setting</li>
                </ol>
            </nav>
        </div>
    </div>
    <!--end breadcrumb-->
    <div class="row">
        <div class="col">
            <h6 class="mb-0 text-uppercase">Setting</h6>
            <hr/>
            <div class="row">
                <div class="col-md-3">
                    <div class="card">
                        <div class="card-body">
                           @include('backend.settings.setting_sidebar')
                        </div>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="card">
                        <div class="card-body">
                            <div class="tab-content" id="pills-tabContent">
                                <form action="{{route('admin.social.media.settings')}}" method="post" enctype="multipart/form-data">
                                    @csrf
                                <div class="tab-pane fade {{Route::is('admin.social.media.settings') ? 'show active' : ''}}" id="primary-pills-general" role="tabpanel">
                                    <div class="col-md-12">
                                        <label for="site-facebook" class="form-label">Facebook</label>
                                        <input type="text" class="form-control @error('site_social_media_facebook')is-invalid @enderror" name="site_social_media_facebook" id="site-facebook" value="{{session('site_social_media_facebook') ?? old('site_social_media_facebook')}}">

                                        @error('site_social_media_facebook')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-12">
                                        <label for="site-instagram" class="form-label">Instagram</label>
                                        <input type="text" class="form-control @error('site_social_media_instagram')is-invalid @enderror" name="site_social_media_instagram" id="site-instagram" value="{{session('site_social_media_instagram') ?? old('site_social_media_instagram')}}" >

                                        @error('site_social_media_instagram')
                                            <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-12 mt-2">
                                        <label for="site-twitter" class="form-label">Twitter</label>
                                        <input type="text" class="form-control @error('site_social_media_twitter')is-invalid @enderror" name="site_social_media_twitter" id="site-footer-text" value="{!!  session('site_social_media_twitter') ?? old('site_social_media_twitter')  !!}">
                                        @error('site_social_media_twitter')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-12 mt-2">
                                        <label for="site-twitter" class="form-label">Youtube</label>
                                        <input type="text" class="form-control @error('site_social_media_youtube')is-invalid @enderror" name="site_social_media_youtube" id="site-footer-text" value="{!!  session('site_social_media_youtube') ?? old('site_social_media_youtube')  !!}">
                                        @error('site_social_media_youtube')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-12 mt-2">
                                        <label for="site-twitter" class="form-label">Linkedin</label>
                                        <input type="text" class="form-control @error('site_social_media_linkedin')is-invalid @enderror" name="site_social_media_linkedin" id="site-footer-text" value="{!!  session('site_social_media_linkedin') ?? old('site_social_media_linkedin')  !!}">
                                        @error('site_social_media_linkedin')
                                        <div class="invalid-feedback" >{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-12 mt-3">
                                        <button type="submit" class="btn btn-primary px-5">Update</button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
