@extends('layouts.frontend.frontend')
@push('meta_tag')
    <title>Report Dashboard</title>
@endpush
@push('front_header')
    @include('layouts.frontend.front_header')
@endpush
@push('front_menu')
    @include('layouts/frontend/front_menu')
@endpush
@section('content')

    <div class="row row-cols-1 row-cols-md-2 row-cols-xl-4">
        <div class="col">
            <a href="{{route('reports.votes')}}">
            <div class="card radius-10 bg-gradient-deepblue">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <h5 class="mb-0 text-white">{{ isset($total_voter) ? $total_voter : 0 }}</h5>
                    </div>
                    <div class="progress my-3 bg-light-transparent" style="height:3px;">
                        <div class="progress-bar bg-white" role="progressbar" style="width: 55%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    <div class="d-flex align-items-center text-white">
                        <p class="mb-0">Total Voter</p>
                    </div>
                </div>
            </div>
            </a>
        </div>
        <div class="col">
            <a href="{{route('reports.votes')}}">
                <div class="card radius-10 bg-gradient-ohhappiness">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <h5 class="mb-0 text-white">{{ isset($total_voting) ? $total_voting : 0 }}</h5>
                        </div>
                        <div class="progress my-3 bg-light-transparent" style="height:3px;">
                            <div class="progress-bar bg-white" role="progressbar" style="width: 55%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <div class="d-flex align-items-center text-white">
                            <p class="mb-0">Total Votes</p>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col">
            <a href="{{route('reports.attendances')}}">
                <div class="card radius-10 bg-gradient-blues">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <h5 class="mb-0 text-white">{{ isset($total_attendance) ? $total_attendance : 0 }}</h5>
                        </div>
                        <div class="progress my-3 bg-light-transparent" style="height:3px;">
                            <div class="progress-bar bg-white" role="progressbar" style="width: 55%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                        <div class="d-flex align-items-center text-white">
                            <p class="mb-0">Total Attendance</p>
                        </div>
                    </div>
                </div>
            </a>

        </div>
    </div>
@endsection

@push('js')


@endpush
