@extends('layouts.frontend.frontend')
@push('front_header')
    @include('layouts.frontend.front_header')
@endpush
@push('front_menu')
    @include('layouts/frontend/front_menu')
@endpush
@push('css')
    <link href="{{asset('assets/dashboard')}}/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <h6 class="mb-0 text-uppercase">Attendances</h6>
            <hr/>
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="login-history-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                            <tr>
                                <th>BO/Folio ID</th>
                                <th >Name</th>
                                <th >Start Time</th>
                                <th >End Time</th>
                                <th >Login Duration</th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')

    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script>

        $(document).ready(function() {
            let table = $('#login-history-datatable').DataTable({
                "lengthMenu": [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
                iDisplayLength: 25,
                "order": [[0, "asc"]],
                processing: true,
                serverSide: true,
                stateSave: true,
                searchDelay: 300,
                ajax: {
                    url: "{!! route('reports.login.histories.datatable') !!}",
                    method: 'GET',
                    data: function ( d ) {
                        return $.extend({}, d, {
                            'search': d.search.value ? d.search.value : ''
                        });
                    }
                },
                columns: [
                    {data: 'bo_id', name: 'BO/Folio ID'},
                    {data: 'name', "name": "Name",},
                    {data: 'entry_time', name: 'Start Time'},
                    {data: 'exit_time', name: 'End Time'},
                    {data: 'duration', name: 'Login Duration'},

                ],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'collection',
                        text: 'Export',
                        buttons: [
                            'excel',
                            'csv',
                        ]
                    }
                ],
                // rowGroup: {
                    // endRender: function ( rows, group ) {
                    //     var avg = rows
                    //         .data()
                    //         .pluck(5)
                    //         .reduce( function (a, b) {
                    //             return a + b.replace(/[^\d]/g, '')*1;
                    //         }, 0) / rows.count();
                    //
                    //     // return 'Average salary in '+group+': '+
                    //     //     $.fn.dataTable.render.number(',', '.', 0, '$').display( avg );
                    // },
                    // dataSrc: function ( row ) {
                    //     return row['bo_id'];
                    // }
                    // dataSrc: 1
                // }
            });
            // table.order( [ 0, 'asc' ])
            table.draw();
        });
    </script>
@endpush
