<?php $__env->startPush('back_header'); ?>
    <?php echo $__env->make('layouts.backend.common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <link href="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/dashboard')); ?>/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" >
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex">
                <h6 class="mb-0 text-uppercase">Agenda</h6>
                <div class="ms-auto">
                    <div class="btn-group">
                        <a href="<?php echo e(route('admin.questions.create')); ?>" class="btn btn-primary">Create</a>
                    </div>
                </div>
            </div>

            <hr/>
            <div class="card">
                <div class="card-body">
                    <div id="question-show-update">

                    </div>
                    <div class="table-responsive">
                        <table id="questions-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Title BN</th>
                                    <th>Details</th>
                                    <th>Details BN</th>
                                    <th>Status</th>
                                    <th>Active</th>
                                    <th style="min-width: 10%">Action</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script>

        $(document).ready(function() {
            let table = $('#questions-datatable').DataTable({
                // "order": [[0, "desc"]],
                processing: true,
                serverSide: true,
                stateSave: true,
                searchDelay: 300,
                ajax: {
                    url: "<?php echo route('admin.datatable.questions'); ?>",
                    data: function ( d ) {
                        return $.extend({}, d, {
                            'search': d.search.value ? d.search.value : ''
                        });
                    }
                },
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'title', name: 'title'},
                    {data: 'title_bn', name: 'title bn'},
                    {data: 'details', name: 'details'},
                    {data: 'details_bn', name: 'details bn'},
                    {data: 'status', name: 'Status'},
                    {data: 'active', name: 'Active'},
                    {data: 'action', name: 'Action'},
                ],
            });
            table.order( [ 0, 'desc' ])
            table.draw();



        });
        function messageShow(agendaId) {
            $.ajax({
                type:'get',
                url: '<?php echo url('admin/question-vote-approve'); ?>/'+agendaId,
                success: function (response) {
                $('#question-show-update').html(` <div class="alert border-0 border-start border-5 border-success alert-dismissible fade show py-2">
                        <div class="d-flex align-items-center">
                            <div class="font-35 text-success"><i class='bx bxs-check-circle'></i>
                            </div>
                            <div class="ms-3">
                                <h6 class="mb-0 text-success">${response ? (response.title ? response.title : ''): '' }</h6>
                                <div>Agenda vote status change successfully</div>
                            </div>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>`);
            },
            errors: function (err) {
                console.log(error)
            },
        })
        }
    </script>
    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/sweetalert2/sweetalert2.all.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/dashboard/js/script.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/agmamcl/resources/views/backend/questions/index.blade.php ENDPATH**/ ?>