<?php $__env->startPush('back_header'); ?>
    <?php echo $__env->make('layouts.backend.common.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <link href="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/dashboard')); ?>/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" >
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex">
                <h6 class="mb-0 text-uppercase">Presentations</h6>
                <div class="ms-auto">
                    <div class="btn-group">
                        <a href="<?php echo e(route('admin.presentations.create')); ?>" class="btn btn-primary">Create</a>
                    </div>
                </div>
            </div>

            <hr/>
            <div class="card">
                <div class="card-body">
                    <div id="question-show-update">

                    </div>
                    <div class="table-responsive">
                        <table id="presentation-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Details</th>
                                    <th>Image</th>
                                    <th>Active</th>
                                    <th style="min-width: 10%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $presentations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $presentation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($presentation->id); ?></td>
                                    <td><?php echo e($presentation->title); ?></td>
                                    <td><?php echo e($presentation->details); ?></td>
                                    <td><?php if($presentation->image): ?> <img src="<?php echo e(asset($presentation->image)); ?>" alt="" style="mad-width: 100px; max-height: 100px"> <?php endif; ?></td>
                                    <td> <button type="button" class="btn btn-outline-<?php echo e($presentation->is_active  == 1 ? 'success' : 'danger'); ?>"> <?php echo e($presentation->is_active == 1 ? 'Publish' : 'Unpublished'); ?></button></td>
                                    <td  class="text-center">
                                        <a href="<?php echo e(route('admin.presentations.edit',$presentation->id)); ?>" class="btn btn-outline-info"><i class='bx bx-pencil me-0'></i></a>
                                        <a class="btn btn-outline-danger" onclick="deleteData('<?php echo e($presentation->id); ?>')"><i class='bx bx-trash me-0'></i></a>
                                        <form id="delete-form-<?php echo e($presentation->id); ?>"
                                              action="<?php echo e(route('admin.presentations.delete',$presentation->id)); ?>" method="POST"
                                              style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/sweetalert2/sweetalert2.all.min.js"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/dashboard/js/script.js')); ?>"></script>
    <script>
        $('#presentation-datatable').DataTable();

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/agmamcl/resources/views/backend/presentations/index.blade.php ENDPATH**/ ?>