<?php $__env->startPush('meta_tag'); ?>
    <title><?php echo e(session('site_title')); ?></title>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('front_header'); ?>
    <?php echo $__env->make('layouts.frontend.front_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12 col-lg-12 col-xl-12 d-flex">
            <div class="card radius-10 w-100">
                <div class="row">
                    <div class="col-sm-12 col-md-7 col-lg-7">
                        <div class="card-body">
                            <div class="card-title">
                                <h5 class="my-4">Login as Shareholder</h5>
                                <hr>
                            </div>
                            <ul class="nav nav-pills nav-pills-success mb-4 " role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" data-bs-toggle="pill" href="#pills-home" role="tab" aria-selected="true">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Individual</div>
                                        </div>
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" data-bs-toggle="pill" href="#pills-profile" role="tab" aria-selected="false">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Organization</div>
                                        </div>
                                    </a>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link" data-bs-toggle="pill" href="#pills-contact" role="tab" aria-selected="false">
                                        <div class="d-flex align-items-center">
                                            <div class="tab-title">Proxy</div>
                                        </div>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="pills-home" role="tabpanel">
                                    <form action="<?php echo e(route('join.individual')); ?>" method="post" id="form-individual">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="bo-id-folio" class="form-label">BO/Folio ID <span class="form-data-required">*</span></label>
                                                    <input class="form-control mb-3" name="bo_folio_id" type="text" id="bo-id-folio" placeholder="Enter Your BO / Folio ID" required>
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="shareholder-name" class="form-label">Shareholder's Name</label>
                                                    <input class="form-control mb-3" name="shareholder_name" id="shareholder-name" type="text" placeholder="Enter Your Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="total-share" class="form-label">Total Shares(As on Record Date) <span class="form-data-required">*</span></label>
                                                    <input class="form-control mb-3" id="total-share" name="total_shares" type="number" placeholder="Enter Your Total Shares(As on Record Date)" step="0.01" required>
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <button class="btn btn-success px-5 " type="submit" value="individual">Login</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>

                                <div class="tab-pane fade" id="pills-profile" role="tabpanel">
                                    <form action="<?php echo e(route('join.company')); ?>" method="post" id="form-company">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-bo-id-folio" class="form-label">BO/Folio ID <span class="form-data-required">*</span></label>
                                                    <input class="form-control mb-3" name="bo_folio_id" type="text" id="company-bo-id-folio" placeholder="Enter Your BO / Folio ID" required>
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-name" class="form-label">Organization Name</label>
                                                    <input class="form-control mb-3" name="organization_name" id="company-name" type="text" placeholder="Enter Your Organization Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-authorized-person-name" class="form-label">Authorized Person Name</label>
                                                    <input class="form-control mb-3" name="authorized_person_name" id="company-authorized-person-name" type="text" placeholder="Enter Your Authorized Person Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="company-total-share" class="form-label">Total Shares(As on Record Date) <span class="form-data-required">*</span></label>
                                                    <input class="form-control mb-3" name="total_shares" id="company-total-share" type="number" placeholder="Enter Your Total Shares(As on Record Date)" required>
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <button class="btn btn-success px-5 " type="submit">Login</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>

                                <div class="tab-pane fade" id="pills-contact" role="tabpanel">
                                    <form action="<?php echo e(route('join.proxy')); ?>" method="post" id="form-proxy">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-bo-id-folio" class="form-label">BO/Folio ID <span class="form-data-required">*</span></label>
                                                    <input class="form-control mb-3" name="bo_folio_id" type="text" id="proxy-bo-id-folio" placeholder="Enter Your BO / Folio ID" required>
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-shareholder-name" class="form-label">Shareholder's Name</label>
                                                    <input class="form-control mb-3" name="shareholder_name" id="proxy-shareholder-name" type="text" placeholder="Enter Your Shareholder's Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-total-share" class="form-label">Total Shares(As on Record Date) <span class="form-data-required">*</span></label>
                                                    <input class="form-control mb-3" name="total_shares" id="proxy-total-share" type="number" placeholder="Enter Your Total Shares(As on Record Date)" required>
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <label for="proxy-authorized-person-name" class="form-label">Authorized Person Name</label>
                                                    <input class="form-control mb-3" name="authorized_person_name" id="proxy-authorized-person-name" type="text" placeholder="Enter Your Authorized Person Name" >
                                                </div>
                                            </div>

                                            <div class="col-sm-10 col-md-10 col-lg-10">
                                                <div class="form-group">
                                                    <button class="btn btn-success px-5 " type="submit">Login</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-5 col-lg-5">
                        <div class="card-body">
                            <div class="card-title">
                                <h5 class="my-4">Login as Board Member/Company Secretary</h5>
                                <hr>
                            </div>
                            <form action="<?php echo e(route('join.secretary')); ?>" method="post" id="form-secretary">
                                <?php echo csrf_field(); ?>
                                <div class="row">

                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <label for="company-login" class="form-label">Login ID</label>
                                            <input class="form-control mb-3" name="board_login_id" type="text" id="company-login" placeholder="Enter Your Login ID" >
                                        </div>
                                    </div>
                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <button class="btn btn-success px-5 " type="submit">Login</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>

                        <div class="card-body">
                            <div class="card-title">
                                <h5 class="my-4">Login as Auditors/Scrutinizer</h5>
                                <hr>
                            </div>
                            <form action="<?php echo e(route('join.auditor')); ?>" method="post" id="form-auditor">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <label for="auditors-login" class="form-label">Login ID</label>
                                            <input class="form-control mb-3" name="auditor_login_id" type="text" id="auditors-login" placeholder="Enter Your Login ID" >
                                        </div>
                                    </div>
                                    <div class="col-sm-10 col-md-10 col-lg-10">
                                        <div class="form-group">
                                            <button class="btn btn-success px-5 " type="submit">Login</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <?php echo JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinIndividualRequest','#form-individual'); ?>

    <?php echo JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinCompanyRequest', '#form-company'); ?>

    <?php echo JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinProxyRequest', '#form-proxy'); ?>

    <?php echo JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinSecretaryRequest', '#form-secretary'); ?>

    <?php echo JsValidator::formRequest('App\Http\Requests\JoinMeeting\JoinAuditorRequest', '#form-auditor'); ?>

    <script type="text/javascript" src="<?php echo e(asset('vendor/jsvalidation/js/jsvalidation.js')); ?>"></script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/agmamcl/resources/views/frontend/home1.blade.php ENDPATH**/ ?>