<?php $__env->startPush('front_header'); ?>
    <?php echo $__env->make('layouts.frontend.front_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('front_menu'); ?>
    <?php echo $__env->make('layouts/frontend/front_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <link href="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <h6 class="mb-0 text-uppercase">Voter List</h6>
            <hr/>
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="attendance-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                            <tr>
                                <th>BO/Folio ID</th>
                                <th class="text-wrap">Name</th>
                                <th class="text-wrap">Total Share</th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="<?php echo e(asset('assets/dashboard')); ?>/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script>

        $(document).ready(function() {
            let table = $('#attendance-datatable').DataTable({
                "lengthMenu": [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
                iDisplayLength: 25,
                // "order": [[3, "desc"]],
                processing: true,
                serverSide: true,
                stateSave: true,
                searchDelay: 300,
                ajax: {
                    url: "<?php echo route('reports.voters.datatable'); ?>",
                    method: 'GET',
                    data: function ( d ) {
                        return $.extend({}, d, {
                            'search': d.search.value ? d.search.value : ''
                        });
                    }
                },
                columns: [
                    {data: 'bo_id', name: 'BO/Folio ID'},
                    {data: 'name', "name": "Name",},
                    {data: 'total_share', name: 'Total Share'},

                ],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'collection',
                        text: 'Export',
                        buttons: [
                            'excel',
                            'csv',
                        ]
                    }
                ]
            });
            // table.order( [ 3, 'asc' ])
            table.draw();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.frontend.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/agmamcl/resources/views/frontend/reports/voters.blade.php ENDPATH**/ ?>