<div align="center">
	<p><img src="art/header.jpg" alt="PowerGrid Logo"></p>
    <p align="center">
        <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Total Downloads" src="https://img.shields.io/packagist/dt/power-components/livewire-powergrid"></a>
        <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Latest Version" src="https://img.shields.io/packagist/v/power-components/livewire-powergrid"></a>
        <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="License" src="https://img.shields.io/packagist/l/power-components/livewire-powergrid"></a>
    </p>
    <a href="https://livewire-powergrid.docsforge.com/" target="_blank">📚 Documentation</a> |
    <a href="#features">🔥 Features</a> |
    <a href="#get-started">⌨️ Get started</a>
</div>

------

# Livewire ⚡PowerGrid⚡

PowerGrid generates Advanced Datatables using Laravel [Livewire](https://laravel-livewire.com).

<br/>

## 🚀 Instant Demo

Get to the demo in 2 commands:

```bash
composer require power-components/livewire-powergrid
```

```bash
php artisan powergrid:demo
```

<br/>

## Features

PowerGrid offers you the following features out of the box:

✅ **Filters & Search**

✅ **Column Sorting**

✅ **Pagination**

✅ **Action checkboxes**

✅ **Action buttons**

✅ **Toggle button**

✅ **Click to edit**

✅ **Click to copy**

✅ **Link inside a table cell**

✅ **Livewire Modal Integration ([Livewire UI](https://github.com/livewire-ui/modal))**

✅ **Data Export to XLSX/CSV ([Spout](https://github.com/box/spout))**

✅ **Queue Export for large tables**

✅ **Works with Bootstrap 5 or Tailwind CSS 2**

✅ **Translations available for 🇺🇸 🇧🇷 🇪🇸 🇮🇹 🇩🇪 and others...**

<br/>

 ![Laravel Livewire Tables](https://github.com/Power-Components/powergrid-doc/blob/main/doc/img/example.gif?raw=true)

------

# Get started

## 1. Requirements

- PHP 7.4.1+
- [Laravel 8x](https://laravel.com/docs/8.x/installation)
- [Livewire 2x](https://laravel-livewire.com)
- [Tailwind](https://tailwindcss.com/docs/guides/laravel) or [Bootstrap 5](https://getbootstrap.com/docs/5.0/getting-started/introduction/)

## 2. Install

Please follow the steps indicated in our [Documentation - Install](https://livewire-powergrid.docsforge.com/main/install/).

## 3. Support

For questions, issues, bug reports and feature requests, please use our [Issues](https://github.com/Power-Components/livewire-powergrid/issues).

Before submitting a new request, please look into our previous issues.

Verify if your bug/question or feature request has been previously submitted.

## 4. How to contribute

🇺🇸 [How to contribute to PowerGrid](https://github.com/Power-Components/como-contribuir-com-o-powergrid/blob/main/README-EN.md) - Translation by [@DanSysAnalyst](https://github.com/DanSysAnalyst)

🇧🇷 [Guia para contribuir com o Powergrid](https://github.com/Power-Components/como-contribuir-com-o-powergrid/) - by [Claudio Pereira](https://github.com/cpereiraweb)

## 5. Credits

Created by: [Luan Freitas](https://github.com/luanfreitasdev)

- [Contributors](../../contributors)
- Logo & artwork by [Caneco](https://github.com/caneco)
