<?php

namespace App\Http\Controllers\Backend\Message;

use App\Events\AllowMessageEvent;
use App\Http\Controllers\Controller;
use App\Models\Message;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class MessageController extends Controller
{
    public function index()
    {
        return view('backend.messages.messages');
    }

    public function datatableMessage()
    {
        $search = \request('search');
        $messages = Message::join('users','messages.user_id', '=', 'users.id')
            ->orderBy('messages.created_at','desc')
            ->when($search, function ($q) use ($search){
                $q->where('users.name','like','%'.$search.'%')
                    ->orWhere('users.company_name','like','%'.$search.'%')
                    ->orWhere('users.shareholder_name','like','%'.$search.'%')
                    ->orWhere('users.bo_id','like','%'.$search.'%')
                    ->orWhere('messages.message','like','%'.$search.'%');
            })
            ->select([
                'messages.id',
                'messages.uuid',
                'messages.message',
                'messages.is_show',
                'users.name as user_name',
                'users.shareholder_name as shareholder_name',
                'users.company_name as company_name',
                'users.bo_id as bo_id',
                'users.user_type as user_type'
            ])->get();

        return DataTables::of($messages)
            ->addColumn('message', function ($message){
                return  wordwrap($message->message,120,"<br>\n");
            })
            ->addColumn('action', function($message){
                $str ='';
                $str = $str.'<div class="form-check form-switch">
									<input class="form-check-input" onclick="messageShow('.$message->id.')" type="checkbox" id="message-show-'.$message->id  .'"'. ($message->is_show == 1 ? "checked" : "") .'>
									<label class="form-check-label" for="message-show-'.$message->id  .'">Show</label>
								</div>';
                return $str;
            })->rawColumns(['action','message'])->make(true);
    }

    public function messageApprove($messageId)
    {
        $message  = Message::where('id', $messageId)->firstOrFail();
        $message->is_show = $message->is_show == 1 ? 0 : 1;
        $message->save();
        $message->load('user');
        broadcast(New AllowMessageEvent());
        return response()->json($message);
    }
}
