<?php

namespace App\Http\Controllers\Backend\QuestionOption;

use App\Http\Controllers\Controller;
use App\Http\Requests\QuestionOption\UpdateQuestionOptionRequest;
use App\Models\Question;
use App\Models\QuestionOptions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class QuestionOptionController extends Controller
{
    public function questionOptions($id)
    {
        $question = Question::where('id', $id)->firstOrFail();
        $question_options = QuestionOptions::where('question_id', $id)->get();
        return view('backend.question_options.index', compact('question_options', 'question'));
    }

    public function questionOptionEdit($id)
    {
        $question_option = QuestionOptions::where('id', $id)->firstOrFail();
        return response()->json($question_option);
    }

    public function questionOptionUpdate(UpdateQuestionOptionRequest $request)
    {
        DB::beginTransaction();
        try {
            QuestionOptions::where('id',$request->option_id)->update([
                'option' => $request->option
            ]);

            DB::commit();
            notify()->success('Question Option Successfully Updated.');
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            notify()->error('Something went wrong!'.$e->getMessage());
            return redirect()->back();
        }
    }
}
