<?php

namespace App\Http\Livewire\Backend;

use App\Events\ConferenceBroadcastEvent;
use App\Models\Setting;
use Livewire\Component;

class BroadcastHandleLivewire extends Component
{

    public $brodcastValue = 'pre_broadcast_video';
    public $broadcast_show = '';

    public function render()
    {
        $broadcast_video_live = Setting::where('name', 'broadcast_video_live')->first();
        if($broadcast_video_live) {
            $this->brodcastValue = $broadcast_video_live->value;
            $this->broadcast_show = Setting::where('name', $this->brodcastValue)->first()->value;
        }

        return view('livewire.backend.broadcast-handle-livewire');
    }

    public function changeBroadcast($broadcast)
    {

        $this->brodcastValue = $broadcast;
        Setting::updateOrCreate(['name' => 'broadcast_video_live'],['value' => $broadcast]);
        $this->broadcast_show = Setting::where('name', $this->brodcastValue)->first()->value;
        broadcast(new ConferenceBroadcastEvent($this->brodcastValue));
    }
}
