<?php

namespace App\Http\Livewire\Frontend;

use App\Models\Setting;
use Livewire\Component;

class BroadcastHandleLivewire extends Component
{

    public $frontBrodcastValue = 'pre_broadcast_video';

    public $frontBroadcastShow = '';

    protected $listeners = [
        "echo-private:ConferenceBroadcasting,ConferenceBroadcastEvent" => 'BroadcastLiveChangeEvent',
    ];
    public function render()
    {
        $broadcast_video_live = Setting::where('name', 'broadcast_video_live')->first();
        if($broadcast_video_live) {
            $this->frontBrodcastValue = $broadcast_video_live->value;
            $this->frontBroadcastShow = Setting::where('name', $this->frontBrodcastValue)->first()->value;
        }
        return view('livewire.frontend.broadcast-handle-livewire');
    }

    public function BroadcastLiveChangeEvent($broadcast_name)
    {
        $this->frontBrodcastValue = $broadcast_name;
        $this->frontBroadcastShow = Setting::where('name', $this->frontBrodcastValue)->first()->value;
    }
}
