<?php

namespace App\Http\Requests\Presentation;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePresentationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title'                         => 'required | string |  max: 200',
            'title_bn'                      => 'nullable | string |  max: 200',
            'details'                       => 'required | string |  max: 1000',
            'details_bn'                    => 'nullable | string |  max: 1000',
            'image'                         => 'nullable | image |  max: 1000',
        ];
    }
}
