<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuestionOptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('question_options', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid');
            $table->foreignId('question_id')->nullable()->constrained()->onDelete('cascade');
            $table->string('option');
            $table->string('type')->nullable()->comment('Yes/No');
            $table->tinyInteger('is_active')->default(1);
            $table->unsignedBigInteger('crated_by')->nullable();
            $table->unsignedBigInteger('update_by')->nullable();
            $table->foreign('crated_by')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('update_by')->references('id')->on('users')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('question_options');
    }
}
