-- --------------------------------------------------------
-- Host:                         localhost
-- Server version:               5.7.24 - MySQL Community Server (GPL)
-- Server OS:                    Win64
-- HeidiSQL Version:             10.2.0.5599
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table charkatextilea.categories
CREATE TABLE IF NOT EXISTS `categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_upload` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_module_id_foreign` (`module_id`),
  CONSTRAINT `categories_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.categories: ~3 rows (approximately)
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` (`id`, `uuid`, `module_id`, `name`, `slug`, `details`, `image`, `file_upload`, `status`, `meta_keyword`, `meta_description`, `deleted_at`, `created_at`, `updated_at`) VALUES
	(1, '00d6ab63-b60b-4e7b-bbbd-258ba045a07b', 7, 'Sleepwear', 'sleepwear', NULL, 'images/categories/00d6ab63-b60b-4e7b-bbbd-258ba045a07b/sleepwearPicture1.png', NULL, 1, NULL, NULL, NULL, '2021-07-08 12:44:05', '2021-07-08 12:44:05'),
	(2, 'd7a2d0f4-c33f-4448-97a1-12e44d10a6d8', 7, 'Underwear', 'underwear', NULL, 'images/categories/d7a2d0f4-c33f-4448-97a1-12e44d10a6d8/underwearPicture2.png', NULL, 1, NULL, NULL, NULL, '2021-07-08 12:44:28', '2021-07-08 14:31:15'),
	(3, '36bfddb2-688c-453c-9d01-80a6fa631198', 7, 'Casualwear', 'casualwear', NULL, 'images/categories/36bfddb2-688c-453c-9d01-80a6fa631198/casualwearPicture1.png', NULL, 1, NULL, NULL, NULL, '2021-07-08 12:44:49', '2021-07-08 16:01:01'),
	(4, '5ca20e8e-b980-40a5-9407-f624858c06c0', 7, 'Activewear', 'activewear', NULL, 'images/categories/5ca20e8e-b980-40a5-9407-f624858c06c0/activewearActivewear-Category.jpg', NULL, 1, NULL, NULL, NULL, '2021-07-13 16:40:56', '2021-07-13 16:40:56');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.common_sections
CREATE TABLE IF NOT EXISTS `common_sections` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subtitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_details` text COLLATE utf8mb4_unicode_ci,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_caption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_upload` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `common_sections_module_id_foreign` (`module_id`),
  CONSTRAINT `common_sections_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.common_sections: ~7 rows (approximately)
/*!40000 ALTER TABLE `common_sections` DISABLE KEYS */;
INSERT INTO `common_sections` (`id`, `uuid`, `module_id`, `title`, `slug`, `subtitle`, `short_details`, `details`, `image`, `image_caption`, `icon_image`, `icon_name`, `file_upload`, `url`, `status`, `meta_keyword`, `meta_description`, `created_at`, `updated_at`, `deleted_at`) VALUES
	(1, 'fbc30341-5ed5-4308-8968-179779941863', 1, '103 Sewing Lines With Latest Machines', '103-sewing-lines-with-latest-machines', NULL, NULL, '** 103 Production Lines ** 4,600 Sets of total machines ** 7,000 Pieces per day Foam Molding ** 7.5 Million pieces per month capacity ** 15,000 Pieces per day Fabric Molding ** 30,000 Pieces per day Lamination facility ** 6,000 Total employees. Including textile mill', 'images/sections/fbc30341-5ed5-4308-8968-179779941863/103-sewing-lines-with-latest-machinesKPy2.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 12:32:12', '2021-07-07 14:48:48', NULL),
	(2, '3aa061ef-0031-4744-9ed7-14df20b18436', 1, 'World Class Knitwear Manufacturer', 'world-class-knitwear-manufacturer', NULL, NULL, '** 700,000 Pieces Bras per month ** 2.00 Million pieces of Girls and Ladies Panties per month ** 2.00 Million pieces Mens Briefs &amp; Boxersper month ** 2.5 Million pieces Other Knit Items per month ** 600 Pieces Sample Room Capacity per day', 'images/sections/3aa061ef-0031-4744-9ed7-14df20b18436/world-class-knitwear-manufacturerMGi1.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 12:33:47', '2021-07-07 12:33:47', NULL),
	(3, '77f04f86-5535-4b82-ab9a-fafe9b82af76', 3, 'Company Profile', 'company-profile', 'ABOUT US', '<p> PRAN RFL group prides itself on being an organization that has performed excellently</p>', '<p> PRAN RFL group prides itself on being an organization that has performed excellently not only on a domestic level but on a global level as well. As an environment-friendly organization, PRAN RFL Group has set an industry-wide benchmark in its home country through its continuous contributions to the economy. </p><p>The talent management within the corporation has allowed its excellent workforce to work together in building an organization that believes in providing equal opportunity for everyone. Also, PRAN RFL acknowledges all the complaints and suggestions given from every single level of the organization. PRAN RFL’s corporate culture is based on maintaining professional integrity. PRAN RFL rewards competence and the workflow is deadline oriented. </p><p>As a company, PRAN RFL has always endorsed environmentalism and understands its responsibility to advocate and practice ecologically beneficial activities. Furthermore, it nurtures the belief of taking care of each of its stakeholders as well as the society at large. And so, PRAN RFL puts its belief into practice by carrying out activities that benefit the economy and thus, the people operating within that economy.</p>', NULL, NULL, 'images/sections/icons/77f04f86-5535-4b82-ab9a-fafe9b82af76/company-profileabout.png', NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 15:06:46', '2021-07-08 09:50:51', NULL),
	(4, '2ce31d74-87be-47db-bab3-92b7d333ac79', 3, 'Mission & Vission', 'mission-vission', 'MISSION & VISSION', '<p> Our mission is to provide global quality standard products by maintaining compliance</p>', '<p><span style="font-size: 20px;">Mission:</span> </p><p>Our mission is to provide global quality standard products by maintaining compliance and ensuring benefits for our employees according to labour law and to explore potential market and opportunities through innovation. </p><p><span style="font-size: 20px;">Vision:</span> </p><p>Chorka Textile Ltd activities will be associated with the highest possible standard of quality to achieve its long term goal and become a frontrunner in sustainability in Textile Industry. Our Sustainability program will promote respect for the environment &amp; comprise interventions of environmental degradation, and become one of the best cohesive textile enterprise, driven by ambitious quality, analysis with a leadership position across merchandise and markets where customer satisfaction will be exceeded. Our customer’s requirements will be fully filled with the best products, and always make them feel that they are receiving prominent value for their money. </p>', NULL, NULL, 'images/sections/icons/2ce31d74-87be-47db-bab3-92b7d333ac79/mission-vissionmission-icon.png', NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 15:14:55', '2021-07-08 10:02:00', NULL),
	(5, '57363fb1-2ea1-461c-ae23-9ab8cb172f4f', 5, 'KNITTING', 'knitting', NULL, 'Equipped with spandex attachments and extra-gauge cylinders, 90 existing', '<p><img src="http://127.0.0.1:8000/filemanager/uploads/Biudlf2.jpg" style="width: 100%; float: left;" class="note-float-left">Equipped with spandex attachments and extra-gauge cylinders, 90 existing knitting machines are used&nbsp; to get knitting the capacity of 20 tons/day, producing a variety of fabrics (single jersey, lycra jersey,&nbsp; slub&nbsp; &nbsp;jersey, modal, viscose, polyester, pique, interlock, rib/drop needle rib, 3-thread fleece, etc.).</p><p></p>', NULL, NULL, 'images/sections/icons/57363fb1-2ea1-461c-ae23-9ab8cb172f4f/knittingSwGknitting.png', NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 16:23:44', '2021-07-11 16:25:14', NULL),
	(6, '9f2657d7-6308-4428-9ac1-c18e5e4b1c6a', 5, 'DYEING', 'dyeing', NULL, '36 bulk dyeing machines are used to obtain the capacity of', '<p style="margin: 0in 0in 0.0001pt; color: rgb(51, 51, 51); font-family: &quot;Helvetica Neue&quot;, Helvetica, Arial, sans-serif; letter-spacing: normal;"><span arial","sans-serif";="" color:#0e101a"=""><font size="3">36 bulk dyeing machines are used to obtain the capacity of 25 tons/day (including samples). The fabric finishing sector is equipped for various types of finishing like enzyme finish, silicone finish, Teflon coating, antimicrobial coating, etc.</font></span></p>', NULL, NULL, 'images/sections/icons/9f2657d7-6308-4428-9ac1-c18e5e4b1c6a/dyeingytndyeing.png', NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 16:29:57', '2021-07-07 16:29:57', NULL),
	(7, '70b87add-622e-47fc-af00-ca7b28c43ea3', 5, 'SEWING', 'sewing', NULL, 'With 103 sewing lines and 4600 Sets of machines dedicated to sewing, Chorka produces', 'With 103 sewing lines and 4600 Sets of machines dedicated to sewing, Chorka produces 7.5 million pieces per month.', NULL, NULL, 'images/sections/icons/70b87add-622e-47fc-af00-ca7b28c43ea3/sewingp2usewing.png', NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 16:31:17', '2021-07-07 16:31:17', NULL),
	(8, 'b3c86e62-2047-42ca-96f0-b21f40522bf1', 9, 'Md. Eleash Mridha', 'md-eleash-mridha', 'Chairman', NULL, NULL, 'images/sections/b3c86e62-2047-42ca-96f0-b21f40522bf1/md-eleash-mridha Md. Eleash Mridha Chairman.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '2021-07-16 22:16:14', '2021-07-16 22:16:14', NULL),
	(9, '6d6692ab-0766-4f57-ad79-54a275e1b1fe', 10, 'ETKO', 'etko', NULL, NULL, NULL, 'images/sections/6d6692ab-0766-4f57-ad79-54a275e1b1fe/etko0001.jpg', NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '2021-07-17 18:10:38', '2021-07-17 18:10:38', NULL);
/*!40000 ALTER TABLE `common_sections` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.contact_mails
CREATE TABLE IF NOT EXISTS `contact_mails` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.contact_mails: ~6 rows (approximately)
/*!40000 ALTER TABLE `contact_mails` DISABLE KEYS */;
INSERT INTO `contact_mails` (`id`, `uuid`, `name`, `email`, `subject`, `message`, `deleted_at`, `created_at`, `updated_at`) VALUES
	(1, 'abebadc3-2366-4d5f-a38d-23b655c8085e', 'Notheing', 'Notheing', 'Notheing', 'Notheing', NULL, '2021-07-24 10:32:34', '2021-07-24 10:32:34'),
	(2, '27fcb52e-86a9-463b-99ec-7b45982eda1d', 'Notheing', 'Notheing', 'Notheing', 'Notheing', NULL, '2021-07-24 10:32:49', '2021-07-24 10:32:49'),
	(3, '941804ac-725a-4589-88a2-b241931bfcc7', 'Notheing', 'Notheing', 'Notheing', 'Notheing', NULL, '2021-07-24 10:33:24', '2021-07-24 10:33:24'),
	(4, '01977d24-f117-4a7a-827c-26ad71b7897b', 'Notheing', 'Notheing', 'Notheing', 'Notheing', NULL, '2021-07-24 10:47:48', '2021-07-24 10:47:48'),
	(5, 'e57f011e-c14f-4f80-bb73-6a993b8e218c', 'Notheing', 'Notheing', 'Notheing', 'Notheing', NULL, '2021-07-24 10:47:58', '2021-07-24 10:47:58'),
	(6, '78564868-4776-493a-bdec-13acac240020', 'Notheing', 'Notheing', 'Notheing', 'Notheing', NULL, '2021-07-24 10:50:40', '2021-07-24 10:50:40'),
	(7, '8b2ee968-6a54-4021-88c9-c1fdd22bcb88', 'Notheing', 'dd@gmail.com', 'ddd', 'beracah.kings\r\nOP\r\nPosted 2 years ago\r\n419 Page Expired\r\nI m trying to submit my form to payment gateway and payment gateway returns the user to the response page in my website. Im able to send the data to the payment gateway and when payment gateway returns the user back to my website, I get 419 | Page Expired error message.\r\n\r\nWhat could be the reason for this error message. Could it be due to csrf token missing from the payment gateway response.\r\n\r\nHow to resolve', NULL, '2021-07-24 16:18:49', '2021-07-24 16:18:49');
/*!40000 ALTER TABLE `contact_mails` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.dealers
CREATE TABLE IF NOT EXISTS `dealers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `sz` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `did` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `distributor_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `proprietor_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thana` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `district` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_list` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `meta_keyword` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dealers_module_id_foreign` (`module_id`),
  CONSTRAINT `dealers_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.dealers: ~0 rows (approximately)
/*!40000 ALTER TABLE `dealers` DISABLE KEYS */;
/*!40000 ALTER TABLE `dealers` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.failed_jobs
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.failed_jobs: ~0 rows (approximately)
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.filemanager
CREATE TABLE IF NOT EXISTS `filemanager` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_size` double(20,2) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `absolute_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `extra` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.filemanager: ~3 rows (approximately)
/*!40000 ALTER TABLE `filemanager` DISABLE KEYS */;
INSERT INTO `filemanager` (`id`, `name`, `ext`, `file_size`, `user_id`, `absolute_url`, `extra`, `created_at`, `updated_at`) VALUES
	(1, 'Biudlf2.jpg', 'jpg', 132298.00, 1, 'http://127.0.0.1:8000/filemanager/uploads/Biudlf2.jpg', '{"width":1920,"height":1080}', '2021-07-07 16:22:12', '2021-07-07 16:22:12'),
	(15, 'Picture3.png', 'png', 557228.00, 1, 'http://127.0.0.1:8000/filemanager/uploads/Picture3.png', '{"width":574,"height":574}', '2021-07-08 12:00:21', '2021-07-08 12:00:21'),
	(16, 'Picture4.png', 'png', 524677.00, 1, 'http://127.0.0.1:8000/filemanager/uploads/Picture4.png', '{"width":513,"height":574}', '2021-07-08 12:00:22', '2021-07-08 12:00:22'),
	(17, 'Picture1.jpg', 'jpg', 107379.00, 1, 'http://127.0.0.1:8000/filemanager/uploads/Picture1.jpg', '{"width":1024,"height":1024}', '2021-07-13 20:06:26', '2021-07-13 20:06:26');
/*!40000 ALTER TABLE `filemanager` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.media
CREATE TABLE IF NOT EXISTS `media` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_caption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `video` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `video_caption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_upload` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_text` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `video_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_module_id_foreign` (`module_id`),
  CONSTRAINT `media_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.media: ~4 rows (approximately)
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` (`id`, `uuid`, `module_id`, `title`, `slug`, `image`, `image_caption`, `video`, `video_caption`, `file_upload`, `file_text`, `video_url`, `status`, `meta_keyword`, `meta_description`, `created_at`, `updated_at`, `deleted_at`) VALUES
	(1, '88d54c22-2c57-45b2-a6be-f5cc68dec439', 6, 'Celio', 'celio', 'images/media/88d54c22-2c57-45b2-a6be-f5cc68dec439/celiocelioz2XUntitled design (6).jpg', NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '2021-07-08 12:18:36', '2021-07-14 07:01:52', NULL),
	(2, '0692c0ec-f9e1-482e-a79f-7a3c3e16d21b', 6, 'Carrefour', 'carrefour', 'images/media/0692c0ec-f9e1-482e-a79f-7a3c3e16d21b/carrefour7L9Untitled design (5).jpg', NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, '2021-07-08 12:20:36', '2021-07-08 12:20:36', NULL),
	(3, '44fe3978-c9fb-407b-969e-c099661ec374', 8, 'Chorka Textile', 'chorka-textile', NULL, NULL, NULL, NULL, NULL, NULL, 'https://www.youtube.com/embed/IZEa8m19otk', 1, NULL, NULL, '2021-07-15 19:49:28', '2021-07-15 22:21:52', NULL),
	(4, 'a365fac3-8545-4850-8d2f-b016a184ba59', 8, 'Textile One', 'textile-one', NULL, NULL, NULL, NULL, NULL, NULL, 'https://www.youtube.com/embed/IZEa8m19otk', 0, NULL, NULL, '2021-07-15 20:18:36', '2021-07-15 20:27:41', NULL),
	(5, '17e3e2ec-362f-41bd-a2ca-bb144537e362', 8, 'ddd', 'ddd', NULL, NULL, NULL, NULL, NULL, NULL, 'https://www.youtube.com/embed/IZEa8m19otk', 0, NULL, NULL, '2021-07-15 20:19:12', '2021-07-15 20:26:14', NULL);
/*!40000 ALTER TABLE `media` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.migrations: ~17 rows (approximately)
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(7, '2014_10_12_000000_create_users_table', 1),
	(8, '2014_10_12_100000_create_password_resets_table', 1),
	(9, '2019_08_19_000000_create_failed_jobs_table', 1),
	(10, '2020_05_02_100001_create_filemanager_table', 1),
	(15, '2021_06_14_041446_create_modules_table', 2),
	(17, '2021_06_14_042126_create_pages_table', 3),
	(18, '2021_06_16_103854_create_common_sections_table', 4),
	(19, '2021_06_19_120343_create_media_table', 5),
	(21, '2021_06_21_122419_create_projects_table', 6),
	(23, '2021_06_23_092816_create_categories_table', 7),
	(24, '2021_06_23_160109_create_sub_categories_table', 8),
	(25, '2021_06_24_093026_create_products_table', 9),
	(26, '2021_06_27_115229_create_product_images_table', 10),
	(29, '2021_06_29_094010_create_show_rooms_table', 11),
	(30, '2021_06_29_111709_create_dealers_table', 12),
	(31, '2021_07_03_090851_create_progress_table', 13),
	(33, '2021_07_04_145629_create_settings_table', 14),
	(34, '2021_07_24_095208_create_contact_mails_table', 15);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.modules
CREATE TABLE IF NOT EXISTS `modules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.modules: ~7 rows (approximately)
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` (`id`, `uuid`, `name`, `slug`, `module_type`, `details`, `image`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
	(1, '1494ba24-d5fa-4d4e-aa69-75d0bed689ab', 'Slider', 'slider', 'section', NULL, NULL, 1, '2021-07-07 12:26:34', '2021-07-07 12:26:34', NULL),
	(2, '00227fbd-2366-4363-93fa-f1cbbf28885a', 'About us', 'about-us', 'page', NULL, NULL, 1, '2021-07-07 12:47:13', '2021-07-07 12:47:13', NULL),
	(3, '73a92d8b-72dc-4aad-a576-717f4e7c881f', 'About Section', 'about-section', 'section', NULL, NULL, 1, '2021-07-07 14:48:34', '2021-07-07 14:48:34', NULL),
	(4, 'eb5fb241-d8ee-4159-b65a-5584c72fe065', 'Chorka Cares', 'chorka-cares', 'page', NULL, NULL, 1, '2021-07-07 15:29:39', '2021-07-08 17:00:24', NULL),
	(5, '42390617-7b3c-439f-b60b-45c5e7524f01', 'Our Strength', 'our-strength', 'section', NULL, NULL, 1, '2021-07-07 16:18:04', '2021-07-07 16:18:04', NULL),
	(6, '045e0d2a-0b46-40e6-aa70-9e764194a795', 'Customers', 'customers', 'media', NULL, NULL, 1, '2021-07-08 12:16:45', '2021-07-08 12:17:40', NULL),
	(7, 'b27db619-4a4f-471c-903c-d83145baebd9', 'Product', 'product', 'multistep', NULL, NULL, 1, '2021-07-08 12:42:23', '2021-07-08 12:42:23', NULL),
	(8, '8a438dc8-23bb-45c8-b1a8-a4239a535190', 'Media Video', 'media-video', 'media', NULL, NULL, 1, '2021-07-15 18:30:13', '2021-07-15 19:53:34', NULL),
	(9, 'a9eab9a6-d581-4c4f-abb9-a02474ae2acf', 'Board Of Directors', 'board-of-directors', 'section', NULL, NULL, 1, '2021-07-16 22:15:36', '2021-07-16 22:15:36', NULL),
	(10, 'd4d96614-c34b-413a-b249-9a10474c085e', 'Certification', 'certification', 'section', NULL, NULL, 1, '2021-07-17 18:05:33', '2021-07-17 18:05:33', NULL);
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.pages
CREATE TABLE IF NOT EXISTS `pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `short_details` text COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_module_id_foreign` (`module_id`),
  CONSTRAINT `pages_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.pages: ~2 rows (approximately)
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` (`id`, `uuid`, `module_id`, `title`, `slug`, `details`, `short_details`, `image`, `url`, `status`, `meta_keyword`, `meta_description`, `created_at`, `updated_at`, `deleted_at`) VALUES
	(1, '5627eeb4-7d0c-442f-8b33-39fe647e34c7', 2, 'About Us', 'about-us', NULL, NULL, NULL, NULL, 1, NULL, NULL, '2021-07-07 12:47:45', '2021-07-07 16:13:39', NULL),
	(2, '2da8fed2-48ff-4802-9ab7-c24d596a9443', 4, 'Chorka Cares', 'chorka-cares', '<p style="text-align: center; "><span style="font-size: 18px;">Making a Difference in the Society</span><span style="font-size: 18px;">We Live in</span></p><p style="text-align: justify;">Chorka’s fundamentals are rooted in the philosophy of going beyond business. The company has a keen eye on the environmental issues plaguing the world and we are more than committed to working collectively to create a safer, thriving world for the citizens of tomorrow. Our actions are reflected in what we do and maintain the integrity of the environment and the communities in every country where we across the globe.</p><p style="text-align: justify;">We are our society and change starts from us; These philosophies are portrayed in even the smallest of everyday tasks within our company. Our managers and floor inspectors are extensively trained to keep a keen eye on any possible wastages at any point of the supply chain. Problem-solvers from this category are justly awarded and incentivized.</p><p style="text-align: justify;">We are proud to introduce our “Mothers @ Work” program for our employees who are expecting their child. Facilitating them via this project, we ensure a fine work-life balance for the new mothers; enabling them to both continue their work life as well as enjoy the priceless blessings of parenthood. Ensuring the nutrition of our workers is also one of our core priorities. Hence, apart from subsidizing the everyday meals, Chorka has also established a Tasty Treat outlet to help the employees indulge in the country’s best bakery items and engage in conversations; leading to cross-departmental sharing of ideas and innovation.</p><p style="text-align: justify;">As a leading conglomerate in the textile arena, we aim to play our part in addressing global and local environmental and social concerns through our actions and working in partnership with stakeholders at local, national and international levels.<br></p>', 'Chorka’s fundamentals are rooted in the philosophy of going beyond business.', 'images/pages/2da8fed2-48ff-4802-9ab7-c24d596a9443/charka-caresSustainability.png', NULL, 1, NULL, NULL, '2021-07-07 16:03:10', '2021-07-08 09:34:37', NULL);
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.password_resets: ~0 rows (approximately)
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.products
CREATE TABLE IF NOT EXISTS `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `sub_category_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_details` text COLLATE utf8mb4_unicode_ci,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `thumbnail` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_upload` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0none, 1latest, 2newarival, 3featured, 4ln, 5lf, 6nf',
  `buy_links` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_module_id_foreign` (`module_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `sub_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.products: ~3 rows (approximately)
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` (`id`, `uuid`, `module_id`, `category_id`, `sub_category_id`, `title`, `slug`, `short_details`, `details`, `thumbnail`, `file_upload`, `type`, `buy_links`, `status`, `meta_keyword`, `meta_description`, `created_at`, `updated_at`, `deleted_at`) VALUES
	(1, 'c7d782fb-6841-44c3-af19-e747f7eff17d', 7, 1, NULL, 'Women\'s Nightwear WC0023L Blue Print', 'womens-nightwear-wc0023l-blue-print', NULL, '<p>Women\'s NightwearItem </p><p>code: 43736Style no: WC0023L</p><p>Brand: Winner Fashion</p><p>Fabric: 100% cotton full body all-over print, round neck, chest attached with lace, Short sleeve</p><p>Size: S, M, L, XL.</p><p>Color: Blueprint (as given picture) </p>', 'images/products/c7d782fb-6841-44c3-af19-e747f7eff17d/thumbnail/womens-nightwear-wc0023l-blue-printwomens-nightwear.jpeg', NULL, 0, NULL, 1, NULL, NULL, '2021-07-10 10:13:39', '2021-07-10 11:42:32', '2021-07-10 11:42:32'),
	(2, 'b16a9a70-78ed-4311-9a21-a169dd7c12c1', 7, 1, NULL, 'Women\'s Nightwear WC0023L Blue Print', 'womens-nightwear-wc0023l-blue-print', NULL, NULL, 'images/products/b16a9a70-78ed-4311-9a21-a169dd7c12c1/thumbnail/womens-nightwear-wc0023l-blue-printwomens-nightwear.jpeg', NULL, 0, NULL, 1, NULL, NULL, '2021-07-10 11:43:49', '2021-07-10 11:44:01', '2021-07-10 11:44:01'),
	(3, '3f33ca28-5000-45d6-a03c-0cf66b02bd25', 7, 2, 1, 'Women\'s Nightwear', 'womens-nightwear', NULL, '<p>Product details: Women\'s Nightwear Item<br>code: 43736 Style no: WC0023L</p><p>Brand: Winner Fashion </p><p>Fabric: 100% cotton Full body all over print, round neck, chest attached with lace, Short sleeve </p><p>Size: S, M, L, XL. Color: Blue print (as given picture)<br></p>', 'images/products/3f33ca28-5000-45d6-a03c-0cf66b02bd25/thumbnail/womens-nightwear-wc0023l-blue-printwomens-nightwear.jpeg', NULL, 0, NULL, 1, NULL, NULL, '2021-07-10 11:44:29', '2021-07-14 06:44:17', NULL);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.product_images
CREATE TABLE IF NOT EXISTS `product_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_images_product_id_foreign` (`product_id`),
  CONSTRAINT `product_images_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.product_images: ~10 rows (approximately)
/*!40000 ALTER TABLE `product_images` DISABLE KEYS */;
INSERT INTO `product_images` (`id`, `uuid`, `product_id`, `image`, `status`, `deleted_at`, `created_at`, `updated_at`) VALUES
	(1, '6aa494db-a916-4461-8eaa-634a2f891b36', 1, 'images/products/c7d782fb-6841-44c3-af19-e747f7eff17d/womens-nightwear-wc0023l-blue-printwomens-nightwear.jpeg', 1, '2021-07-10 11:42:32', '2021-07-10 10:13:39', '2021-07-10 11:42:32'),
	(2, '5dbadb04-7a37-46bc-894b-9977d5223f17', 2, 'images/products/b16a9a70-78ed-4311-9a21-a169dd7c12c1/womens-nightwear-wc0023l-blue-print0110157_womens-nightwear-wc0023l-blue-print.jpeg', 1, '2021-07-10 11:44:01', '2021-07-10 11:43:49', '2021-07-10 11:44:01'),
	(3, 'b1d9ed5d-ac37-4470-bd47-ab9fef5e81f0', 2, 'images/products/b16a9a70-78ed-4311-9a21-a169dd7c12c1/womens-nightwear-wc0023l-blue-print0110158_womens-nightwear-wc0023l-blue-print.jpeg', 1, '2021-07-10 11:44:01', '2021-07-10 11:43:49', '2021-07-10 11:44:01'),
	(4, '27ab3be1-0499-4801-9a7f-132a4af11f7c', 2, 'images/products/b16a9a70-78ed-4311-9a21-a169dd7c12c1/womens-nightwear-wc0023l-blue-printwomens-nightwear.jpeg', 1, '2021-07-10 11:44:01', '2021-07-10 11:43:49', '2021-07-10 11:44:01'),
	(5, 'efe1c72e-51ec-4346-89d4-015dc75780a9', 3, 'images/products/3f33ca28-5000-45d6-a03c-0cf66b02bd25/womens-nightwear-wc0023l-blue-print0110157_womens-nightwear-wc0023l-blue-print.jpeg', 1, '2021-07-10 12:45:29', '2021-07-10 11:44:29', '2021-07-10 12:45:29'),
	(6, '82f56c1b-247a-4427-a69a-a1e729d830f2', 3, 'images/products/3f33ca28-5000-45d6-a03c-0cf66b02bd25/womens-nightwear-wc0023l-blue-print0110158_womens-nightwear-wc0023l-blue-print.jpeg', 1, '2021-07-10 12:18:32', '2021-07-10 11:44:29', '2021-07-10 12:18:32'),
	(7, '4eea3b60-4725-4e22-ba16-ae541f0fc51c', 3, 'images/products/3f33ca28-5000-45d6-a03c-0cf66b02bd25/womens-nightwear-wc0023l-blue-printwomens-nightwear.jpeg', 1, '2021-07-10 12:45:13', '2021-07-10 11:44:29', '2021-07-10 12:45:13'),
	(8, '29c7db51-0078-4be0-a538-46ba36fa4608', 3, 'images/products/3f33ca28-5000-45d6-a03c-0cf66b02bd25/womens-nightwear-wc0023l-blue-print0110157_womens-nightwear-wc0023l-blue-print.jpeg', 1, '2021-07-11 10:26:54', '2021-07-10 12:46:08', '2021-07-11 10:26:54'),
	(9, 'd5d2b931-bf5c-49d1-87e7-e5a2f0211f7f', 3, 'images/products/3f33ca28-5000-45d6-a03c-0cf66b02bd25/womens-nightwear-wc0023l-blue-print0110158_womens-nightwear-wc0023l-blue-print.jpeg', 1, '2021-07-11 10:27:02', '2021-07-10 12:46:08', '2021-07-11 10:27:02'),
	(10, '91c350af-7f04-4ec2-9eaa-37db9e4314f8', 3, 'images/products/3f33ca28-5000-45d6-a03c-0cf66b02bd25/womens-nightwear-wc0023l-blue-printwomens-nightwear.jpeg', 1, '2021-07-11 10:26:58', '2021-07-10 12:46:08', '2021-07-11 10:26:58');
/*!40000 ALTER TABLE `product_images` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.progress
CREATE TABLE IF NOT EXISTS `progress` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `percentage` double(6,2) DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `meta_keyword` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `progress_module_id_foreign` (`module_id`),
  CONSTRAINT `progress_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.progress: ~4 rows (approximately)
/*!40000 ALTER TABLE `progress` DISABLE KEYS */;
INSERT INTO `progress` (`id`, `uuid`, `module_id`, `title`, `slug`, `quantity`, `percentage`, `status`, `meta_keyword`, `meta_description`, `deleted_at`, `created_at`, `updated_at`) VALUES
	(1, 'c7116c90-d39a-489d-af42-8be6d4545314', NULL, 'Total Employees', 'total-employees', 6500, NULL, 1, NULL, NULL, NULL, '2021-07-08 11:07:48', '2021-07-08 11:07:48'),
	(2, 'd2b000f2-18eb-4497-ac03-64ddb90ec633', NULL, 'Sewing Capacity(Pcs./Day)', 'sewing-capacitypcsday', 266667, NULL, 1, NULL, NULL, NULL, '2021-07-08 11:08:08', '2021-07-08 11:08:08'),
	(3, '19a4a140-8eac-49f5-a178-dadccd6191a9', NULL, 'Knitting Capacity(Kg./Day)', 'knitting-capacitykgday', 25000, NULL, 1, NULL, NULL, NULL, '2021-07-08 11:08:26', '2021-07-08 11:08:26'),
	(4, '0c37cb1a-60c5-4a80-98fb-60ca59f1114a', NULL, 'Dyeing Capacity(Kg./Day)', 'dyeing-capacitykgday', 25000, NULL, 1, NULL, NULL, NULL, '2021-07-08 11:08:51', '2021-07-08 11:08:51');
/*!40000 ALTER TABLE `progress` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.projects
CREATE TABLE IF NOT EXISTS `projects` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `short_details` text COLLATE utf8mb4_unicode_ci,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_caption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_upload` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_completed` tinyint(4) NOT NULL DEFAULT '0',
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_module_id_foreign` (`module_id`),
  CONSTRAINT `projects_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.projects: ~0 rows (approximately)
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.settings
CREATE TABLE IF NOT EXISTS `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.settings: ~19 rows (approximately)
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` (`id`, `name`, `value`, `created_at`, `updated_at`) VALUES
	(1, 'site_title', 'Chorka Textile Ltd.', '2021-07-04 18:06:31', '2021-07-11 12:05:09'),
	(2, 'site_description', 'First demo', '2021-07-04 18:06:31', '2021-07-05 11:11:59'),
	(3, 'site_address', 'PRAN-RFL Center,\r\n105 Middle Badda,\r\nDhaka-1212.', '2021-07-04 18:06:31', '2021-07-05 10:42:45'),
	(4, 'site_contact', '09613-737777', '2021-07-05 10:44:23', '2021-07-05 10:44:23'),
	(5, 'site_email', 'crd@prangroup.com', '2021-07-05 10:44:23', '2021-07-05 10:44:23'),
	(6, 'site_toll_free_contact', '09613-737777', '2021-07-05 10:44:23', '2021-07-05 10:44:23'),
	(7, 'site_name', 'Chorka Textile Ltd.', '2021-07-05 11:54:45', '2021-07-11 12:05:09'),
	(8, 'site_logo', 'images/settings/appearance/logologo.png', '2021-07-05 12:26:50', '2021-07-11 12:04:10'),
	(9, 'site_sm_logo', 'images/settings/appearance/smlogofavicon.png', '2021-07-05 12:26:50', '2021-07-11 12:04:10'),
	(10, 'site_favicon', 'images/settings/appearance/faviconfavicon.png', '2021-07-05 12:26:50', '2021-07-11 12:04:10'),
	(11, 'site_og_image', 'images/settings/appearance/siteogimageriver.jpg', '2021-07-05 12:30:31', '2021-07-05 12:30:31'),
	(12, 'site_google_map', 'https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d1085.4660182358234!2d90.4258673226207!3d23.78095121813421!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x7ff1d179fba4c47c!2sPRAN%20Center!5e0!3m2!1sen!2sbd!4v1625993826041!5m2!1sen!2sbd', '2021-07-11 15:06:47', '2021-07-11 15:06:47'),
	(13, 'site_factory_google_map', 'https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d8675.937106448542!2d90.57356838354669!3d23.897340522278608!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x6b86bd3a3c2b8adc!2sChorka%20Textile%20Ltd.!5e0!3m2!1sen!2sbd!4v1625994570144!5m2!1sen!2sbd', '2021-07-11 15:06:47', '2021-07-11 15:09:52'),
	(14, 'site_facebook', 'https://www.facebook.com/Chorkatex', '2021-07-11 16:18:54', '2021-07-11 16:18:54'),
	(15, 'site_instagram', 'https://www.facebook.com/Chorkatex', '2021-07-11 16:18:54', '2021-07-11 16:18:54'),
	(16, 'site_footer_about', NULL, '2021-07-11 16:18:54', '2021-07-11 16:18:54'),
	(17, 'site_footer_logo', 'images/settings/footer/footerlogologo.png', '2021-07-11 16:18:54', '2021-07-11 16:18:54'),
	(18, 'site_download_profile', 'images/settings/appearance/downloadprofilecompany authorization letter.pdf', '2021-07-11 16:19:50', '2021-07-11 16:19:50'),
	(19, 'site_footer_text', 'Chorka Textile Ltd is a 100% export-oriented manufacturer of readymade garments (Lingerie products). It’s located in Kazir Char, Danga, Pal', '2021-07-11 17:27:45', '2021-07-11 17:28:02');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.show_rooms
CREATE TABLE IF NOT EXISTS `show_rooms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `show_room_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manager_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1',
  `meta_keyword` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `show_rooms_module_id_foreign` (`module_id`),
  CONSTRAINT `show_rooms_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.show_rooms: ~0 rows (approximately)
/*!40000 ALTER TABLE `show_rooms` DISABLE KEYS */;
/*!40000 ALTER TABLE `show_rooms` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.sub_categories
CREATE TABLE IF NOT EXISTS `sub_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) unsigned DEFAULT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_upload` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sub_categories_module_id_foreign` (`module_id`),
  KEY `sub_categories_category_id_foreign` (`category_id`),
  CONSTRAINT `sub_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sub_categories_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.sub_categories: ~2 rows (approximately)
/*!40000 ALTER TABLE `sub_categories` DISABLE KEYS */;
INSERT INTO `sub_categories` (`id`, `uuid`, `module_id`, `category_id`, `name`, `slug`, `details`, `image`, `file_upload`, `status`, `meta_keyword`, `meta_description`, `deleted_at`, `created_at`, `updated_at`) VALUES
	(1, '88bb6f2d-fc63-4395-9aaf-40be5fce2fdf', 7, 2, 'Men’s Underwear', 'mens-underwear', NULL, 'images/subcategories/88bb6f2d-fc63-4395-9aaf-40be5fce2fdf/mens-underwearUnderwear.jpg', NULL, 1, NULL, NULL, NULL, '2021-07-08 12:45:37', '2021-07-10 09:37:24'),
	(2, 'a3176630-395e-4e06-a1a5-a516db913f9e', 7, 2, 'Women’s Panties', 'womens-panties', NULL, 'images/subcategories/a3176630-395e-4e06-a1a5-a516db913f9e/womens-pantiesLadies_UnderGarments.jpg', NULL, 1, NULL, NULL, NULL, '2021-07-08 12:46:10', '2021-07-10 09:41:04');
/*!40000 ALTER TABLE `sub_categories` ENABLE KEYS */;

-- Dumping structure for table charkatextilea.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table charkatextilea.users: ~0 rows (approximately)
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `uuid`, `name`, `email`, `email_verified_at`, `password`, `role_id`, `remember_token`, `created_at`, `updated_at`) VALUES
	(1, '4b288ea7-46e3-4daa-a7c0-e4087a8fc416', 'admin', 'admin@mail.com', '2021-06-15 09:36:51', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 1, 'LdOIt6q5ivv7mflIgqeIfVNw9V5au9aiidc5WX8hgsc9dyX7lM2ABD8pWmq4', '2021-06-15 09:36:51', '2021-06-15 09:36:51');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
