@extends('layouts.frontend.frontend')
@push('back_header')
    @include('layouts.backend.common.header')
@endpush
@push('css')
    <link href="{{asset('assets/dashboard')}}/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="{{ asset('assets/dashboard') }}/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" >
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex">
                <h6 class="mb-0 text-uppercase">Presentations</h6>
                <div class="ms-auto">
                    <div class="btn-group">
                        <a href="{{route('admin.presentations.create')}}" class="btn btn-primary">Create</a>
                    </div>
                </div>
            </div>

            <hr/>
            <div class="card">
                <div class="card-body">
                    <div id="question-show-update">

                    </div>
                    <div class="table-responsive">
                        <table id="presentation-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Details</th>
                                    <th>Image</th>
                                    <th>Active</th>
                                    <th style="min-width: 10%">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @forelse($presentations as $presentation)
                                <tr>
                                    <td>{{$presentation->id}}</td>
                                    <td>{{$presentation->title}}</td>
                                    <td>{{$presentation->details}}</td>
                                    <td>@if($presentation->image) <img src="{{asset($presentation->image)}}" alt="" style="mad-width: 100px; max-height: 100px"> @endif</td>
                                    <td> <button type="button" class="btn btn-outline-{{$presentation->is_active  == 1 ? 'success' : 'danger'}}"> {{$presentation->is_active == 1 ? 'Publish' : 'Unpublished'}}</button></td>
                                    <td  class="text-center">
                                        <a href="{{route('admin.presentations.edit',$presentation->id)}}" class="btn btn-outline-info"><i class='bx bx-pencil me-0'></i></a>
                                        <a class="btn btn-outline-danger" onclick="deleteData('{{ $presentation->id }}')"><i class='bx bx-trash me-0'></i></a>
                                        <form id="delete-form-{{ $presentation->id }}"
                                              action="{{ route('admin.presentations.delete',$presentation->id) }}" method="POST"
                                              style="display: none;">
                                            @csrf()
                                            @method('DELETE')
                                        </form>
                                    </td>
                                </tr>
                            @empty
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/sweetalert2/sweetalert2.all.min.js"></script>
    <script type="text/javascript" src="{{ asset('assets/dashboard/js/script.js')}}"></script>
    <script>
        $('#presentation-datatable').DataTable();

    </script>
@endpush
