@extends('layouts.frontend.frontend')
@push('back_header')
    @include('layouts.backend.common.header')
@endpush
@push('css')
    <link href="{{asset('assets/dashboard')}}/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="{{ asset('assets/dashboard') }}/plugins/sweetalert2/sweetalert2.min.css" rel="stylesheet" >
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="d-flex">
                <h6 class="mb-0 text-uppercase">Question Options</h6>
                <div class="ms-auto">
                    <div class="btn-group">
                        <a href="{{route('admin.questions.index')}}" class="btn btn-dark"><i class="lni lni-chevron-left"></i>{{ __('Back to list') }}</a>
                    </div>
                </div>
            </div>
            <hr/>

            <div class="row">
                <div class="col-md-4">
                    <form  method="POST" id="form-edit-question-option" action="{{ route('admin.question.options.update')  }}" >
                        @csrf
                        <div class="row">
                            <div class="col-xl-12 mx-auto">
                                <div class="card border-top border-0 border-4 border-success">
                                    <div class="card-body p-5">
                                        <div class="row g-3">
                                            <div class="col-md-12">
                                                <label for="form-option" class="form-label">Option <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control @error('option')is-invalid @enderror" name="option" id="form-option">
                                                <input type="hidden"  name="option_id" id="form-option-id">
                                                @error('option')
                                                    <div class="invalid-feedback" >{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12 mt-3">
                                                <button type="submit" class="btn btn-primary px-5">Update  </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-body">

                            <div id="question-show-update">

                            </div>
                            <div class="table-responsive">
                                <table id="questions-datatable" class="table table-striped table-bordered" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th colspan="3">{{$question->title}}</th>
                                        </tr>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th style="min-width: 10%">Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>

                                    @forelse($question_options as $question_option)
                                        <tr>
                                            <td>{{$question_option->id}}</td>
                                            <td>{{$question_option->option}}</td>
                                            <td  class="text-center">
                                                <button type="button" onclick="questionOptionEdit({{$question_option->id}})" class="btn btn-outline-info"><i class='bx bx-pencil me-0'></i></button>

                                            </td>
                                        </tr>
                                    </tbody>
                                    @empty

                                    @endforelse
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@push('js')

    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/sweetalert2/sweetalert2.all.min.js"></script>
    <script type="text/javascript" src="{{ asset('assets/dashboard/js/script.js')}}"></script>

    <script>
        // $(document).ready(function (){
        //     $('#add-question-option').on('click',function (){
        //         let option_type = $('#form-question-type').val();
        //         if(option_type === 'yes/no') {
        //             $('#question-option-area').
        //             console.log('yes/no')
        //         }
        //     });
        // })
        {{--<div class="col-md-12">--}}
        {{--    <input type="text" class="form-control @error('title')is-invalid @enderror" name="title" id="title" value="{{ isset($question) ? $question->title : old('title') }}" autocomplete="title" autofocus>--}}
        {{--        @error('title')--}}
        {{--        <div class="invalid-feedback" >{{ $message }}</div>--}}
        {{--    @enderror--}}
        {{--</div>--}}

        function questionOptionEdit(questionOptionId) {
            $.ajax({
                type:'get',
                url: '{!! url('admin/question-options-edit') !!}/'+questionOptionId,
                success: function (response) {
                    console.log(response)
                    if(response) {
                        $('#form-option').val(response.option);
                        $('#form-option-id').val(response.id);
                    }
                },
                errors: function (err) {
                    console.log(error)
                },
            })
        }


    </script>
    {!! JsValidator::formRequest('App\Http\Requests\QuestionOption\UpdateQuestionOptionRequest','#form-edit-question-option') !!}
    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>
@endpush
