@extends('layouts.frontend.frontend')
@push('front_header')
    @include('layouts.frontend.front_header')
@endpush
@push('front_menu')
    @include('layouts/frontend/front_menu')
@endpush
@push('css')
    <link href="{{asset('assets/dashboard')}}/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <h6 class="mb-0 text-uppercase">Voter List</h6>
            <hr/>
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="attendance-datatable" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                            <tr>
                                <th>BO/Folio ID</th>
                                <th class="text-wrap">Name</th>
                                <th class="text-wrap">Total Share</th>
                            </tr>
                            </thead>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@push('js')

    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('assets/dashboard')}}/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script>

        $(document).ready(function() {
            let table = $('#attendance-datatable').DataTable({
                "lengthMenu": [ [5, 10, 25, 50, -1], [5, 10, 25, 50, "All"] ],
                iDisplayLength: 25,
                // "order": [[3, "desc"]],
                processing: true,
                serverSide: true,
                stateSave: true,
                searchDelay: 300,
                ajax: {
                    url: "{!! route('reports.voters.datatable') !!}",
                    method: 'GET',
                    data: function ( d ) {
                        return $.extend({}, d, {
                            'search': d.search.value ? d.search.value : ''
                        });
                    }
                },
                columns: [
                    {data: 'bo_id', name: 'BO/Folio ID'},
                    {data: 'name', "name": "Name",},
                    {data: 'total_share', name: 'Total Share'},

                ],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'collection',
                        text: 'Export',
                        buttons: [
                            'excel',
                            'csv',
                        ]
                    }
                ]
            });
            // table.order( [ 3, 'asc' ])
            table.draw();
        });
    </script>
@endpush
